/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.nio.ByteBuffer;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.WebSocketRequestImpl;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpMethodDecoder;
import org.smartboot.http.server.decode.WebSocketFrameDecoder;
import org.smartboot.http.utils.AttachKey;
import org.smartboot.http.utils.Attachment;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;

public class HttpRequestProtocol
implements Protocol<Request> {
    public static final AttachKey<WebSocketRequestImpl> ATTACH_KEY_WS_REQ = AttachKey.valueOf("ws");
    public static final Decoder HTTP_FINISH_DECODER = (byteBuffer, cacheChars, aioSession, request) -> null;
    public static final Decoder WS_HANDSHARK_DECODER = (byteBuffer, cacheChars, aioSession, request) -> null;
    public static final Decoder WS_FRAME_DECODER = (byteBuffer, cacheChars, aioSession, request) -> null;
    static final AttachKey<Request> ATTACH_KEY_REQUEST = AttachKey.valueOf("request");
    private static final ThreadLocal<char[]> CHAR_CACHE_LOCAL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };
    private static final AttachKey<Decoder> ATTACH_KEY_DECHDE_CHAIN = AttachKey.valueOf("decodeChain");
    private final HttpMethodDecoder httpMethodDecoder = new HttpMethodDecoder();
    private final WebSocketFrameDecoder wsFrameDecoder = new WebSocketFrameDecoder();

    public Request decode(ByteBuffer buffer, AioSession session) {
        Decoder decodeChain;
        Attachment attachment = (Attachment)session.getAttachment();
        Request request = attachment.get(ATTACH_KEY_REQUEST);
        char[] cacheChars = CHAR_CACHE_LOCAL.get();
        if (cacheChars.length < buffer.remaining()) {
            cacheChars = new char[buffer.remaining()];
            CHAR_CACHE_LOCAL.set(cacheChars);
        }
        if ((decodeChain = attachment.get(ATTACH_KEY_DECHDE_CHAIN)) == null) {
            decodeChain = this.httpMethodDecoder;
        }
        if ((decodeChain = decodeChain.deocde(buffer, cacheChars, session, request)) == HTTP_FINISH_DECODER || decodeChain == WS_HANDSHARK_DECODER || decodeChain == WS_FRAME_DECODER) {
            if (decodeChain == HTTP_FINISH_DECODER) {
                attachment.remove(ATTACH_KEY_DECHDE_CHAIN);
            } else {
                attachment.put(ATTACH_KEY_DECHDE_CHAIN, this.wsFrameDecoder);
            }
            return request;
        }
        attachment.put(ATTACH_KEY_DECHDE_CHAIN, decodeChain);
        if (buffer.remaining() == buffer.capacity()) {
            throw new RuntimeException("buffer is too small when decode " + decodeChain.getClass().getName() + " ," + request);
        }
        return null;
    }
}

