/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XSessionBase;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;

public class _SocketSession
extends XSessionBase {
    public static Map<WebSocketRequest, _SocketSession> sessions = new HashMap<WebSocketRequest, _SocketSession>();
    WebSocketRequest request;
    WebSocketResponse response;
    private String _sessionId = XUtil.guid();
    private String _path;
    private boolean isOpen = true;
    private Object _attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static _SocketSession get(WebSocketRequest req, WebSocketResponse res) {
        _SocketSession tmp = sessions.get(req);
        if (tmp == null) {
            WebSocketRequest webSocketRequest = req;
            synchronized (webSocketRequest) {
                tmp = sessions.get(req);
                if (tmp == null) {
                    tmp = new _SocketSession(req, res);
                    sessions.put(req, tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(WebSocketRequest real) {
        sessions.remove(real);
    }

    public _SocketSession(WebSocketRequest request, WebSocketResponse response) {
        this.request = request;
        this.response = response;
    }

    public Object real() {
        return this.request;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public XMethod method() {
        return XMethod.WEBSOCKET;
    }

    public String path() {
        if (this._path == null) {
            this._path = URI.create(this.request.getRequestURI()).getPath();
        }
        return this._path;
    }

    public void send(String message) {
        this.response.sendTextMessage(message);
    }

    public void send(byte[] message) {
        ByteBuffer buf = ByteBuffer.wrap(message);
        this.response.sendBinaryMessage(buf.array());
    }

    public void send(XMessage message) {
        this.send(message.content());
    }

    public void close() throws IOException {
        this.isOpen = false;
        this.response.close();
        sessions.remove(this.request);
    }

    protected void onClose() {
        this.isOpen = false;
    }

    public boolean isValid() {
        return this.isOpen;
    }

    public boolean isSecure() {
        return this.request.getRequestURI().startsWith("wss:");
    }

    public InetSocketAddress getRemoteAddress() {
        return this.request.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.request.getLocalAddress();
    }

    public void setAttachment(Object obj) {
        this._attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this._attachment;
    }

    public Collection<XSession> getOpenSessions() {
        return new ArrayList<_SocketSession>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)((Object)o);
        return Objects.equals(this.request, that.request);
    }

    public int hashCode() {
        return Objects.hash(this.request);
    }
}

