/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.XUtil;
import org.noear.solon.boot.smarthttp.MultipartUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.enums.HttpStatus;

public class SmartHttpContext
extends XContext {
    private HttpRequest _request;
    private HttpResponse _response;
    protected Map<String, List<XFile>> _fileMap;
    private String _ip;
    private URI _uri;
    private String _url;
    private XMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private XMap _cookieMap;
    private XMap _headerMap;
    private String _charset = "UTF-8";
    protected ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();
    private int _status = 200;

    public SmartHttpContext(HttpRequest request, HttpResponse response) {
        this._request = request;
        this._response = response;
        if (this.isMultipart()) {
            try {
                this._fileMap = new HashMap<String, List<XFile>>();
                MultipartUtil.buildParamsAndFiles(this);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._ip == null) {
            this._ip = this.header("X-Forwarded-For");
            if (this._ip == null) {
                this._ip = this._request.getRemoteAddr();
            }
        }
        return this._ip;
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL();
        }
        return this._url;
    }

    public long contentLength() {
        try {
            return this._request.getContentLength();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String body() throws IOException {
        InputStream inpStream = this.bodyAsStream();
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        int lens = -1;
        while ((lens = inpStream.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        return content.toString();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public String[] paramValues(String key) {
        return this._request.getParameterValues(key);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public String param(String key, String def) {
        try {
            String temp = (String)this.paramMap().get((Object)key);
            if (XUtil.isEmpty((String)temp)) {
                return def;
            }
            return temp;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return def;
        }
    }

    public XMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new XMap();
            try {
                for (Map.Entry entry : this._request.getParameters().entrySet()) {
                    this._paramMap.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            this._request.getParameters().forEach((k, v) -> this._paramsMap.put((String)k, Arrays.asList(v)));
        }
        return this._paramsMap;
    }

    public List<XFile> files(String key) throws Exception {
        if (this.isMultipartFormData()) {
            List<XFile> temp = this._fileMap.get(key);
            if (temp == null) {
                return new ArrayList<XFile>();
            }
            return temp;
        }
        return new ArrayList<XFile>();
    }

    public String cookie(String key) {
        return (String)this.cookieMap().get((Object)key);
    }

    public String cookie(String key, String def) {
        String temp = (String)this.cookieMap().get((Object)key);
        if (temp == null) {
            return def;
        }
        return temp;
    }

    public XMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new XMap();
            String _cookieMapStr = this.header("Cookie");
            if (_cookieMapStr != null) {
                String[] cookies;
                for (String c1 : cookies = _cookieMapStr.split(";")) {
                    String[] ss = c1.trim().split("=");
                    if (ss.length != 2) continue;
                    this._cookieMap.put(ss[0].trim(), (Object)ss[1].trim());
                }
            }
        }
        return this._cookieMap;
    }

    public String header(String key) {
        return (String)this.headerMap().get((Object)key);
    }

    public String header(String key, String def) {
        String temp = this.header(key);
        if (temp == null) {
            return def;
        }
        return temp;
    }

    public XMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new XMap();
            for (String k : this._request.getHeaderNames()) {
                this._headerMap.put(k, (Object)this._request.getHeader(k));
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._charset = charset;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this._charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this._charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        return this._outputStream;
    }

    public void output(String str) {
        try {
            ByteArrayOutputStream out = this._outputStream;
            out.write(str.getBytes(this._charset));
            out.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            ByteArrayOutputStream out = this._outputStream;
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                ((OutputStream)out).write(buff, 0, rc);
            }
            out.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=").append(val).append(";");
        if (XUtil.isNotEmpty((String)path)) {
            sb.append("path=").append(path).append(";");
        }
        if (maxAge >= 0) {
            sb.append("max-age=").append(maxAge).append(";");
        }
        if (XUtil.isNotEmpty((String)domain)) {
            sb.append("domain=").append(domain.toLowerCase()).append(";");
        }
        this._response.setHeader("Set-Cookie", sb.toString());
    }

    public void redirect(String url) {
        this.redirect(url, 302);
    }

    public void redirect(String url, int code) {
        try {
            this.headerSet("Location", url);
            this.status(code);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public int status() {
        return this._status;
    }

    public void status(int status) {
        this._status = status;
    }

    protected void commit() throws IOException {
        this._response.setHttpStatus(HttpStatus.valueOf((int)this.status()));
        this._response.setContentLength(this._outputStream.size());
        this._outputStream.writeTo(this._response.getOutputStream());
    }
}

