/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.enums.HttpMethodEnum;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.logging.RunLogger;
import org.smartboot.http.server.handle.HttpHandle;
import org.smartboot.http.utils.Mimetypes;
import org.smartboot.http.utils.StringUtils;

public class HttpStaticResourceHandle
extends HttpHandle {
    private static final int READ_BUFFER = 0x100000;
    private static final String URL_404 = "<html><head><title>smart-http 404</title></head><body><h1>smart-http \u627e\u4e0d\u5230\u4f60\u6240\u8bf7\u6c42\u7684\u5730\u5740\u8d44\u6e90\uff0c404</h1></body></html>";
    private ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        }
    };
    private File baseDir;

    public HttpStaticResourceHandle(String baseDir) {
        this.baseDir = new File(new File(baseDir).getAbsolutePath());
        if (!this.baseDir.isDirectory()) {
            throw new RuntimeException(baseDir + " is not a directory");
        }
        RunLogger.getLogger().log(Level.FINEST, "dir is:" + this.baseDir.getAbsolutePath());
    }

    @Override
    public void doHandle(HttpRequest request, HttpResponse response) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        String fileName = request.getRequestURI();
        String method = request.getMethod();
        if (StringUtils.endsWith(fileName, "/")) {
            fileName = fileName + "index.html";
        }
        RunLogger.getLogger().log(Level.FINEST, "\u8bf7\u6c42URL:" + fileName);
        File file = new File(this.baseDir, URLDecoder.decode(fileName, "utf8"));
        if (!file.isFile()) {
            RunLogger.getLogger().log(Level.WARNING, "file:" + request.getRequestURI() + " not found!");
            response.setHttpStatus(HttpStatus.NOT_FOUND);
            response.setHeader("Content-Type", "text/html; charset=utf-8");
            if (!HttpMethodEnum.HEAD.getMethod().equals(method)) {
                response.write(URL_404.getBytes());
            }
            return;
        }
        Date lastModifyDate = new Date(file.lastModified());
        try {
            String requestModified = request.getHeader("If-Modified-Since");
            if (StringUtils.isNotBlank(requestModified) && lastModifyDate.getTime() <= this.sdf.get().parse(requestModified).getTime()) {
                response.setHttpStatus(HttpStatus.NOT_MODIFIED);
                return;
            }
        }
        catch (Exception e) {
            RunLogger.getLogger().log(Level.SEVERE, "exception", e);
        }
        response.setHeader("Last-Modified", this.sdf.get().format(lastModifyDate));
        String contentType = Mimetypes.getInstance().getMimetype(file);
        response.setHeader("Content-Type", contentType + "; charset=utf-8");
        if (HttpMethodEnum.HEAD.getMethod().equals(method)) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        FileChannel fileChannel = fis.getChannel();
        long fileSize = fileChannel.size();
        for (long readPos = 0L; readPos < fileSize; readPos += (long)mappedByteBuffer.remaining()) {
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, readPos, fileSize - readPos > 0x100000L ? 0x100000L : fileSize - readPos);
            byte[] data = new byte[mappedByteBuffer.remaining()];
            mappedByteBuffer.get(data);
            response.write(data);
        }
        fis.close();
    }
}

