/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.server.HttpRequestProtocol;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.utils.AttachKey;
import org.smartboot.http.utils.Attachment;
import org.smartboot.http.utils.FixedLengthFrameDecoder;
import org.smartboot.http.utils.SmartDecoder;
import org.smartboot.socket.transport.AioSession;

class HttpBodyDecoder
implements Decoder {
    private final AttachKey<SmartDecoder> ATTACH_KEY_FIX_LENGTH_DECODER = AttachKey.valueOf("fixLengthDecoder");

    HttpBodyDecoder() {
    }

    @Override
    public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
        Attachment attachment = (Attachment)aioSession.getAttachment();
        SmartDecoder smartDecoder = attachment.get(this.ATTACH_KEY_FIX_LENGTH_DECODER);
        if (smartDecoder == null) {
            smartDecoder = new FixedLengthFrameDecoder(request.getContentLength());
            attachment.put(this.ATTACH_KEY_FIX_LENGTH_DECODER, smartDecoder);
        }
        if (smartDecoder.decode(byteBuffer)) {
            request.setFormUrlencoded(new String(smartDecoder.getBuffer().array()));
            attachment.remove(this.ATTACH_KEY_FIX_LENGTH_DECODER);
            return HttpRequestProtocol.HTTP_FINISH_DECODER;
        }
        return this;
    }
}

