/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import org.noear.solon.boot.smarthttp.websocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;
import org.noear.solon.extend.xsocket.XSocketContextHandler;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.server.handle.WebSocketDefaultHandle;

public class WebSocketHandleImp
extends WebSocketDefaultHandle {
    private XSocketContextHandler handler = new XSocketContextHandler(XMethod.WEBSOCKET);
    private XListener listener = XListenerProxy.getGlobal();

    public void onHandShark(WebSocketRequest request, WebSocketResponse response) {
        this.listener.onOpen((XSession)_SocketSession.get(request, response));
    }

    public void onClose(WebSocketRequest request, WebSocketResponse response) {
        _SocketSession session = _SocketSession.get(request, response);
        session.onClose();
        this.listener.onClose((XSession)session);
        _SocketSession.remove(request);
    }

    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        try {
            _SocketSession session = _SocketSession.get(request, response);
            XMessage message = XMessage.wrap((String)request.getRequestURI(), (byte[])data.getBytes("UTF-8"));
            this.listener.onMessage((XSession)session, message);
            if (!message.getHandled()) {
                this.handler.handle((XSession)session, message, true);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        try {
            _SocketSession session = _SocketSession.get(request, response);
            XMessage message = XMessage.wrap((String)request.getRequestURI(), (byte[])data);
            this.listener.onMessage((XSession)session, message);
            if (!message.getHandled()) {
                this.handler.handle((XSession)session, message, false);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onError(Throwable error) {
    }
}

