/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.noear.solon.boot.jetty.JettyServer;
import org.noear.solon.boot.jetty.http.JtJspStarter;
import org.noear.solon.boot.jetty.jsp.JspTldLocator;

class JettyServerAddJsp
extends JettyServer {
    JettyServerAddJsp() {
    }

    @Override
    protected Handler buildHandler() throws IOException {
        ServletContextHandler handler = this.getServletHandler();
        this.enableJspSupport(handler);
        this.addTdlSupport((ServletContext)handler.getServletContext());
        return handler;
    }

    private void enableJspSupport(ServletContextHandler handler) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "solon.boot.jetty");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        handler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        handler.setClassLoader((ClassLoader)jspClassLoader);
        handler.addBean((Object)new JtJspStarter(handler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        handler.addServlet(holderJsp, "*.jsp");
    }

    private void addTdlSupport(ServletContext servletContext) throws IOException {
        Map<String, TaglibDescriptor> tagLibInfos = JspTldLocator.createTldInfos("templates");
        if (tagLibInfos.size() > 0) {
            ServletContextHandler.JspConfig jspConfig = (ServletContextHandler.JspConfig)servletContext.getJspConfigDescriptor();
            if (jspConfig == null) {
                jspConfig = new ServletContextHandler.JspConfig();
                ((ServletContextHandler.Context)servletContext).setJspConfigDescriptor((JspConfigDescriptor)jspConfig);
            }
            for (TaglibDescriptor descriptor : tagLibInfos.values()) {
                jspConfig.addTaglibDescriptor(descriptor);
            }
        }
    }
}

