/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.XPluginImp;
import org.noear.solon.boot.jetty.http.JtHttpRequestWrapper;
import org.noear.solon.boot.web.FormUrlencodedUtils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.web.servlet.SolonServletHandler;

public class JtHttpContextServletHandler
extends SolonServletHandler {
    private File _tempdir;
    private boolean _deleteFiles;
    private int _fileOutputBuffer = 0;
    private long _maxBodySize;
    private long _maxFileSize;

    public void init() throws ServletException {
        super.init();
        this._tempdir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(this.getServletConfig().getInitParameter("deleteFiles"));
        String fileOutputBuffer = this.getServletConfig().getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        this._maxBodySize = ServerProps.request_maxBodySize > 0L ? ServerProps.request_maxBodySize : -1L;
        this._maxFileSize = ServerProps.request_maxFileSize > 0L ? ServerProps.request_maxFileSize : -1L;
    }

    protected void preHandle(Context ctx) throws IOException {
        if (ServerProps.output_meta) {
            ctx.headerSet("Solon-Boot", XPluginImp.solon_boot_ver());
        }
        FormUrlencodedUtils.pretreatment((Context)ctx);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            MultipartConfigElement config = new MultipartConfigElement(this._tempdir.getCanonicalPath(), this._maxFileSize, this._maxBodySize, this._fileOutputBuffer);
            request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)config);
            if (ServerProps.request_useTempfile) {
                BufferedInputStream in = new BufferedInputStream((InputStream)request.getInputStream());
                String ct = request.getContentType();
                MultiPartInputStreamParser multiPartParser = new MultiPartInputStreamParser((InputStream)in, ct, config, this._tempdir);
                multiPartParser.setDeleteOnExit(this._deleteFiles);
                multiPartParser.setWriteFilesWithFilenames(true);
                request = new JtHttpRequestWrapper((HttpServletRequest)request, multiPartParser);
            }
        }
        super.service(request, response);
    }
}

