/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.noear.solon.Solon;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.XPluginImp;
import org.noear.solon.boot.web.FormUrlencodedUtils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.web.servlet.SolonServletContext;

public class JtHttpContextHandler
extends AbstractHandler {
    public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.handleDo(baseRequest, request, response);
        }
        catch (Throwable e) {
            EventBus.publishTry((Object)e);
            response.setStatus(500);
        }
    }

    private void handleDo(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SolonServletContext ctx = new SolonServletContext(request, response);
        ctx.attrSet("signal", (Object)XPluginImp.signal());
        ctx.contentType("text/plain;charset=UTF-8");
        if (ServerProps.output_meta) {
            ctx.headerSet("Solon-Boot", XPluginImp.solon_boot_ver());
        }
        FormUrlencodedUtils.pretreatment((Context)ctx);
        Solon.app().tryHandle((Context)ctx);
        if (ctx.getHandled() || ctx.status() >= 200) {
            baseRequest.setHandled(true);
        } else {
            response.setStatus(404);
            baseRequest.setHandled(true);
        }
    }
}

