/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.jetty.XServerProp;
import org.noear.solon.boot.jetty.http.JtContainerInitializerProxy;
import org.noear.solon.boot.jetty.http.JtHttpContextServletHandler;

class PluginJettyBase {
    PluginJettyBase() {
    }

    protected ServletContextHandler getServletHandler() throws IOException {
        ServletContextHandler handler = new ServletContextHandler();
        handler.setContextPath("/");
        handler.addServlet(JtHttpContextServletHandler.class, "/");
        handler.setBaseResource((Resource)new ResourceCollection(this.getResourceURLs()));
        if (Solon.global().enableSessionState()) {
            handler.setSessionHandler(new SessionHandler());
            if (XServerProp.session_timeout > 0) {
                handler.getSessionHandler().setMaxInactiveInterval(XServerProp.session_timeout);
            }
        }
        handler.addLifeCycleListener((LifeCycle.Listener)new JtContainerInitializerProxy((ServletContext)handler.getServletContext()));
        return handler;
    }

    protected String[] getResourceURLs() throws FileNotFoundException {
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        boolean isDebug = Solon.cfg().isDebugMode();
        if (isDebug && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            String debugResURL = resURL.substring(0, endIndex) + "src/main/resources/";
            return new String[]{debugResURL, resURL};
        }
        return new String[]{resURL};
    }

    protected URL getRootPath() {
        URL root = Utils.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            String path = Utils.getResource((String)"").toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

