/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.PluginJettyBase;
import org.noear.solon.boot.jetty.XServerProp;
import org.noear.solon.boot.jetty.http.JtHttpContextHandler;
import org.noear.solon.boot.jetty.websocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.socketd.SessionManager;

class PluginJetty
extends PluginJettyBase
implements Plugin {
    protected Server _server = null;

    PluginJetty() {
    }

    public void start(SolonApp app) {
        try {
            this.setup(app);
            this._server.start();
        }
        catch (Throwable ex) {
            throw Utils.throwableWrap((Throwable)ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(SolonApp app) throws Throwable {
        Class wsClz = Utils.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
        this._server = new Server(app.port());
        if (Solon.global().enableSessionState()) {
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
        }
        if (app.enableWebSocket() && wsClz != null) {
            this._server.setHandler((Handler)new HandlerHub(this.buildHandler()));
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        } else {
            this._server.setHandler(this.buildHandler());
        }
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)XServerProp.request_maxRequestSize);
        app.cfg().forEach((k, v) -> {
            String key = k.toString();
            if (key.indexOf(".jetty.") > 0) {
                this._server.setAttribute(key, v);
            }
        });
        app.cfg().onChange((k, v) -> {
            if (k.indexOf(".jetty.") > 0) {
                this._server.setAttribute(k, v);
            }
        });
        EventBus.push((Object)this._server);
    }

    protected Handler buildHandler() throws IOException {
        if (Utils.loadClass((String)"org.eclipse.jetty.servlet.ServletContextHandler") == null) {
            JtHttpContextHandler _handler = new JtHttpContextHandler();
            if (Solon.global().enableSessionState()) {
                SessionHandler s_handler = new SessionHandler();
                if (XServerProp.session_timeout > 0) {
                    s_handler.setMaxInactiveInterval(XServerProp.session_timeout);
                }
                s_handler.setHandler((Handler)_handler);
                return s_handler;
            }
            return _handler;
        }
        return this.getServletHandler();
    }
}

