/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.noear.solon.boot.jetty.websocket._SocketSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.extend.xsocket.ListenerProxy;

public class WebSocketListenerImp
extends WebSocketAdapter {
    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        ListenerProxy.getGlobal().onOpen(_SocketSession.get(this.getSession()));
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(payload, offset, len);
            org.noear.solon.core.message.Session session = _SocketSession.get(this.getSession());
            Message message = Message.wrap((String)this.getSession().getUpgradeRequest().getOrigin(), (byte[])buf.array());
            ListenerProxy.getGlobal().onMessage(session, message, false);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onWebSocketText(String text) {
        try {
            org.noear.solon.core.message.Session session = _SocketSession.get(this.getSession());
            Message message = Message.wrap((String)this.getSession().getUpgradeRequest().getRequestURI().toString(), (byte[])text.getBytes("UTF-8"));
            ListenerProxy.getGlobal().onMessage(session, message, true);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        ListenerProxy.getGlobal().onClose(_SocketSession.get(this.getSession()));
        _SocketSession.remove(this.getSession());
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketError(Throwable cause) {
        ListenerProxy.getGlobal().onError(_SocketSession.get(this.getSession()), cause);
    }
}

