/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.websocket.api.Session;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;

public class _SocketSession
implements XSession {
    public static Map<Session, XSession> sessions = new HashMap<Session, XSession>();
    Session real;
    private String _sessionId = XUtil.guid();
    private String _path;
    private boolean _open = true;
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSession get(Session real) {
        XSession tmp = sessions.get(real);
        if (tmp == null) {
            Session session = real;
            synchronized (session) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketSession(real);
                    sessions.put(real, tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(Session real) {
        sessions.remove(real);
    }

    public _SocketSession(Session real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public XMethod method() {
        return XMethod.WEBSOCKET;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.real.getUpgradeRequest().getRequestURI().getPath();
        }
        return this._path;
    }

    public void send(String message) {
        try {
            this.real.getRemote().sendString(message);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void send(byte[] message) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(message);
            this.real.getRemote().sendBytes(buf);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void send(XMessage message) {
        this.send(message.content());
    }

    public void close() throws IOException {
        this._open = false;
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return this._open && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getLocalAddress();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<XSession> getOpenSessions() {
        return new ArrayList<XSession>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)o;
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

