/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.http.HttpPartFile;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.jdkhttp.JdkHttpContext;
import org.noear.solon.boot.jdkhttp.uploadfile.HttpMultipart;
import org.noear.solon.boot.jdkhttp.uploadfile.HttpMultipartCollection;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.UploadedFile;

class MultipartUtil {
    MultipartUtil() {
    }

    public static void buildParamsAndFiles(JdkHttpContext context, Map<String, List<UploadedFile>> filesMap) throws IOException {
        try {
            HttpMultipartCollection parts = new HttpMultipartCollection((HttpExchange)context.request());
            while (parts.hasNext()) {
                HttpMultipart part = parts.next();
                String name = ServerProps.urlDecode((String)part.getName());
                if (MultipartUtil.isFile(part)) {
                    MultipartUtil.doBuildFiles(name, filesMap, part);
                    continue;
                }
                context.paramSet(name, part.getString());
            }
        }
        catch (Exception e) {
            throw new StatusException("Bad Request", (Throwable)e, 400);
        }
    }

    private static void doBuildFiles(String name, Map<String, List<UploadedFile>> filesMap, HttpMultipart part) throws IOException {
        List<UploadedFile> list = filesMap.get(name);
        if (list == null) {
            list = new ArrayList<UploadedFile>();
            filesMap.put(name, list);
        }
        String contentType = part.getHeaders().get("Content-Type");
        String filename = part.getFilename();
        String extension = null;
        int idx = filename.lastIndexOf(".");
        if (idx > 0) {
            extension = filename.substring(idx + 1);
        }
        HttpPartFile partFile = new HttpPartFile(filename, (InputStream)new LimitedInputStream(part.getBody(), ServerProps.request_maxFileSize));
        UploadedFile f1 = new UploadedFile(() -> ((HttpPartFile)partFile).delete(), contentType, partFile.getSize(), partFile.getContent(), filename, extension);
        list.add(f1);
    }

    private static boolean isField(HttpMultipart filePart) {
        return filePart.getFilename() == null;
    }

    private static boolean isFile(HttpMultipart filePart) {
        return !MultipartUtil.isField(filePart);
    }
}

