/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.noear.solon.XApp;
import org.noear.solon.boot.jdkhttp.JdkHttpContextHandler;
import org.noear.solon.boot.jdkhttp.ParameterFilter;
import org.noear.solon.boot.jdkhttp.XServerProp;
import org.noear.solon.core.XPlugin;

public final class XPluginImp
implements XPlugin {
    private HttpServer _server = null;

    public static String solon_boot_ver() {
        return "jdk http jdk8/1.0.30";
    }

    public void start(XApp app) {
        if (!app.enableHttp) {
            return;
        }
        XServerProp.init();
        long time_start = System.currentTimeMillis();
        System.out.println("solon.Server:main: Sun.net.HttpServer jdk8");
        try {
            this._server = HttpServer.create(new InetSocketAddress(app.port()), 0);
            HttpContext context = this._server.createContext("/", new JdkHttpContextHandler());
            context.getFilters().add(new ParameterFilter());
            this._server.setExecutor(Executors.newCachedThreadPool());
            this._server.start();
            long time_end = System.currentTimeMillis();
            System.out.println("solon.Connector:main: Started ServerConnector@{HTTP/1.1,[http/1.1]}{0.0.0.0:" + app.port() + "}");
            System.out.println("solon.Server:main: Started @" + (time_end - time_start) + "ms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop(0);
        this._server = null;
        System.out.println("solon.Server:main: Has Stopped " + XPluginImp.solon_boot_ver());
    }
}

