/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.lang.Nullable;
import org.noear.solon.web.vertx.VxHandler;
import org.noear.solon.web.vertx.VxWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxWebHandler
implements VxHandler {
    static final Logger log = LoggerFactory.getLogger(VxWebHandler.class);
    private @Nullable Executor executor;
    private @Nullable Handler handler;

    protected void preHandle(Context ctx) throws IOException {
    }

    @Override
    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void handle(HttpServerRequest request) {
        block4: {
            HttpServerResponse response = request.response();
            try {
                if ("GET".equals(request.method().name())) {
                    this.handleDo(request, null, false);
                } else {
                    request.bodyHandler(body -> this.handleDo(request, (Buffer)body, true));
                }
            }
            catch (Throwable ex) {
                log.warn(ex.getMessage(), ex);
                if (response.ended()) break block4;
                response.setStatusCode(500);
                response.end();
            }
        }
    }

    private void handleDo(HttpServerRequest request, Buffer requestBody, boolean disPool) {
        VxWebContext ctx = new VxWebContext(request, requestBody);
        if (this.executor == null || disPool) {
            this.handle0(ctx);
        } else {
            try {
                this.executor.execute(() -> this.handle0(ctx));
            }
            catch (RejectedExecutionException e) {
                this.handle0(ctx);
            }
        }
    }

    private void handle0(VxWebContext ctx) {
        try {
            this.preHandle((Context)ctx);
            if (this.handler == null) {
                Solon.app().tryHandle((Context)ctx);
            } else {
                this.handler.handle((Context)ctx);
            }
            if (!ctx.asyncStarted()) {
                ctx.innerCommit();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            ctx.innerGetResponse().setStatusCode(500);
            ctx.innerGetResponse().end();
        }
    }
}

