/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sse;

import java.time.Duration;

public class SseEvent {
    private final StringBuilder buf = new StringBuilder();

    public SseEvent id(String id) {
        this.buf.append("id:").append(id).append('\n');
        return this;
    }

    public SseEvent name(String name) {
        this.buf.append("event:").append(name).append('\n');
        return this;
    }

    public SseEvent reconnectTime(long reconnectTimeMillis) {
        return this.retry(reconnectTimeMillis);
    }

    public SseEvent retry(Duration duration) {
        return this.retry(duration.toMillis());
    }

    public SseEvent retry(long reconnectTimeMillis) {
        this.buf.append("retry:").append(String.valueOf(reconnectTimeMillis)).append('\n');
        return this;
    }

    public SseEvent data(Object object) {
        this.buf.append("data:").append(object.toString()).append('\n');
        return this;
    }

    public SseEvent comment(String comment) {
        this.buf.append(":").append(comment.replace("\n", "\n:")).append('\n');
        return this;
    }

    @Deprecated
    public String build() {
        return this.toString();
    }

    public String toString() {
        return this.buf.toString();
    }
}

