/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import jakarta.servlet.ServletContext;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.Future;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonWebSocketEndpoint
extends Endpoint {
    private final String SESSION_KEY = "session";
    private static final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public static void addEndpoint(ServletContext sc) {
        ServerContainer serverContainer = (ServerContainer)sc.getAttribute("jakarta.websocket.server.ServerContainer");
        if (serverContainer == null) {
            throw new IllegalStateException("Missing jakarta.websocket.server.ServerContainer");
        }
        Collection paths = WebSocketRouter.getInstance().getPaths();
        try {
            for (String path : paths) {
                if (!path.startsWith("/")) continue;
                ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(SolonWebSocketEndpoint.class, (String)path).build();
                serverContainer.addEndpoint(endpointConfig);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        WebSocketImpl socket = new WebSocketImpl(session);
        session.getUserProperties().put("session", socket);
        session.addMessageHandler((MessageHandler)new BufferMessageHandler((WebSocket)socket));
        session.addMessageHandler((MessageHandler)new TextMessageHandler((WebSocket)socket));
    }

    public void onClose(Session session, CloseReason closeReason) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        webSocketRouter.getListener().onClose(socket);
    }

    public void onError(Session session, Throwable thr) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        webSocketRouter.getListener().onError(socket, thr);
    }

    private static class WebSocketImpl
    extends WebSocketBase {
        private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
        private Session real;

        public WebSocketImpl(Session real) {
            this.real = real;
            this.init(real.getRequestURI());
        }

        public boolean isValid() {
            return !this.isClosed() && this.real.isOpen();
        }

        public boolean isSecure() {
            return this.real.isSecure();
        }

        public InetSocketAddress remoteAddress() {
            return null;
        }

        public InetSocketAddress localAddress() {
            return null;
        }

        public long getIdleTimeout() {
            return this.real.getMaxIdleTimeout();
        }

        public void setIdleTimeout(long idleTimeout) {
            this.real.setMaxIdleTimeout(idleTimeout);
        }

        public Future<Void> send(String text) {
            return this.real.getAsyncRemote().sendText(text);
        }

        public Future<Void> send(ByteBuffer binary) {
            return this.real.getAsyncRemote().sendBinary(binary);
        }

        public void close() {
            block2: {
                super.close();
                try {
                    this.real.close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("{}", (Throwable)e);
                }
            }
        }
    }

    private static class BufferMessageHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private WebSocket socket;

        public BufferMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(ByteBuffer s) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, s);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }

    private static class TextMessageHandler
    implements MessageHandler.Whole<String> {
        private WebSocket socket;

        public TextMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(String s) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, s);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }
}

