/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonTestApp;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.test.SolonTest;
import org.noear.solon.test.annotation.Rollback;
import org.noear.solon.test.annotation.TestPropertySource;
import org.noear.solon.test.annotation.TestRollback;
import org.noear.solon.test.aot.SolonAotTestProcessor;
import org.noear.solon.test.data.RollbackInterceptor;

public class RunnerUtils {
    private static Map<Class<?>, AppContext> appCached = new HashMap();

    private static Class<?> getMainClz(SolonTest anno, Class<?> klass) {
        if (anno == null) {
            return klass;
        }
        Class<?> mainClz = anno.value();
        if (mainClz == Void.class) {
            mainClz = anno.classes();
        }
        if (mainClz == Void.class) {
            return klass;
        }
        return mainClz;
    }

    private static Method getMainMethod(Class<?> mainClz) {
        try {
            return mainClz.getMethod("main", String[].class);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void addPropertySource(AppContext context, List<String> propertySources) throws Throwable {
        if (propertySources == null) {
            return;
        }
        for (String uri : propertySources) {
            URL url = ResourceUtil.findResource((String)uri);
            context.cfg().loadAdd(url);
        }
    }

    public static Object initTestTarget(AppContext appContext, Object tmp) {
        appContext.beanInject(tmp);
        BeanWrap beanWrap = new BeanWrap(appContext, tmp.getClass(), tmp);
        appContext.beanExtractOrProxy(beanWrap);
        if (beanWrap.proxy() != null) {
            appContext.beanInject(beanWrap.raw());
        }
        tmp = beanWrap.get();
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppContext initRunner(Class<?> klass) throws Throwable {
        if (klass.getPackage() == null || Utils.isEmpty((String)klass.getPackage().getName())) {
            throw new IllegalStateException("The test class is missing package: " + klass.getName());
        }
        SolonTest anno = klass.getAnnotation(SolonTest.class);
        if (anno != null) {
            Class<?> mainClz;
            if (anno.properties().length > 0) {
                for (String tmp : anno.properties()) {
                    String[] kv = tmp.split("=");
                    if (kv.length != 2) continue;
                    System.setProperty(kv[0], kv[1]);
                }
            }
            ArrayList<String> argsAry = new ArrayList<String>();
            if (anno.args().length > 0) {
                argsAry.addAll(Arrays.asList(anno.args()));
            }
            if (anno.debug()) {
                argsAry.add("-debug=1");
            }
            if (Utils.isNotEmpty((String)anno.env())) {
                argsAry.add("-env=" + anno.env());
            }
            if (appCached.containsKey(mainClz = RunnerUtils.getMainClz(anno, klass))) {
                return appCached.get(mainClz);
            }
            try {
                if (anno.isAot()) {
                    System.setProperty("solon.aot.processing", "true");
                }
                AppContext appContext = RunnerUtils.startDo(mainClz, argsAry, klass);
                if (anno.isAot()) {
                    new SolonAotTestProcessor(mainClz).process(appContext);
                }
                appCached.put(mainClz, appContext);
                if (anno.delay() > 0) {
                    try {
                        Thread.sleep(anno.delay() * 1000);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                AppContext appContext2 = appContext;
                return appContext2;
            }
            finally {
                System.clearProperty("solon.aot.processing");
            }
        }
        ArrayList<String> argsAry = new ArrayList<String>();
        argsAry.add("-debug=1");
        return RunnerUtils.startDo(klass, argsAry, klass);
    }

    private static AppContext startDo(Class<?> mainClz, List<String> argsAry, Class<?> klass) throws Throwable {
        if (mainClz == klass) {
            String[] args = argsAry.toArray(new String[argsAry.size()]);
            SolonTestApp testApp = new SolonTestApp(mainClz, NvMap.from((String[])args));
            testApp.start((ConsumerEx<SolonApp>)((ConsumerEx)x -> RunnerUtils.initDo(klass, x)));
            return testApp.context();
        }
        Method main = RunnerUtils.getMainMethod(mainClz);
        if (main != null && Modifier.isStatic(main.getModifiers())) {
            String[] args = argsAry.toArray(new String[argsAry.size()]);
            RunnerUtils.initDo(klass, null);
            main.invoke(null, new Object[]{args});
            return Solon.context();
        }
        String[] args = argsAry.toArray(new String[argsAry.size()]);
        SolonTestApp testApp = new SolonTestApp(mainClz, NvMap.from((String[])args));
        testApp.start((ConsumerEx<SolonApp>)((ConsumerEx)x -> RunnerUtils.initDo(klass, x)));
        return testApp.context();
    }

    private static void initDo(Class<?> klass, SolonApp app) throws Throwable {
        Import anno2;
        ArrayList<String> propertySources = new ArrayList<String>();
        TestPropertySource anno1 = klass.getAnnotation(TestPropertySource.class);
        if (anno1 != null) {
            for (String s1 : anno1.value()) {
                propertySources.add(s1);
            }
        }
        if ((anno2 = klass.getAnnotation(Import.class)) != null) {
            for (String s1 : anno2.profiles()) {
                propertySources.add(s1);
            }
        }
        if (app == null) {
            EventBus.subscribe(AppInitEndEvent.class, event -> RunnerUtils.initContextDo(klass, event.context(), propertySources));
        } else {
            RunnerUtils.initContextDo(klass, app.context(), propertySources);
        }
    }

    private static void initContextDo(Class<?> klass, AppContext context, List<String> propertySources) throws Throwable {
        RunnerUtils.addPropertySource(context, propertySources);
        context.beanInterceptorAdd(TestRollback.class, (Interceptor)new RollbackInterceptor(), 120);
        context.beanInterceptorAdd(Rollback.class, (Interceptor)new RollbackInterceptor(), 120);
        context.beanInjectorAdd(Mock.class, (varH, anno) -> {
            Object val = Mockito.mock((Class)varH.getType(), (Answer)anno.answer());
            varH.setValue(val);
        });
    }
}

