/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.statemachine;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.noear.solon.lang.Preview;
import org.noear.solon.statemachine.Event;
import org.noear.solon.statemachine.State;
import org.noear.solon.statemachine.StateContext;

@Preview(value="3.4")
public class StateTransition<S extends State, E extends Event, T> {
    private final S from;
    private final S to;
    private final E event;
    private final BiPredicate<StateContext<S, E, T>, T> condition;
    private final Consumer<StateContext<S, E, T>> action;

    public StateTransition(S from, S to, E event) {
        this(from, to, event, (ctx, payload) -> true, ctx -> {});
    }

    public StateTransition(S from, S to, E event, Consumer<StateContext<S, E, T>> action) {
        this(from, to, event, (ctx, payload) -> true, action);
    }

    public StateTransition(S from, S to, E event, BiPredicate<StateContext<S, E, T>, T> condition, Consumer<StateContext<S, E, T>> action) {
        this.from = from;
        this.to = to;
        this.event = event;
        this.condition = condition;
        this.action = action;
    }

    public S getFrom() {
        return this.from;
    }

    public S getTo() {
        return this.to;
    }

    public E getEvent() {
        return this.event;
    }

    public boolean matches(S state, E event, T payload) {
        return this.from.equals(state) && this.event.equals(event) && this.condition.test((StateContext<S, E, StateContext<S, E, T>>)new StateContext<S, E, T>(this.from, this.to, event, payload), (StateContext<S, E, T>)payload);
    }

    public void execute(StateContext<S, E, T> context) {
        this.action.accept(context);
    }
}

