/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.java_websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    private final WebSocket real;

    public WebSocketImpl(WebSocket real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getResourceDescriptor());
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.hasSSLSupport();
    }

    public InetSocketAddress remoteAddress() {
        return this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress localAddress() {
        return this.real.getLocalSocketAddress();
    }

    public Future<Void> send(String text) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.send(text);
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.send(binary);
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public void close() {
        block3: {
            super.close();
            if (this.real.isOpen()) {
                try {
                    this.real.close();
                }
                catch (Throwable ignore) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Close failure: {}", (Object)ignore.getMessage());
                }
            }
        }
    }

    public void close(int code, String reason) {
        block3: {
            super.close(code, reason);
            if (this.real.isOpen()) {
                try {
                    this.real.close(code, reason);
                }
                catch (Throwable ignore) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Close failure: {}", (Object)ignore.getMessage());
                }
            }
        }
    }
}

