/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.undertow.UndertowServer;
import org.noear.solon.server.undertow.http.UtHttpContextServletHandler;
import org.noear.solon.server.undertow.jsp.JspResourceManager;
import org.noear.solon.server.undertow.jsp.JspServletEx;
import org.noear.solon.server.util.DebugUtils;

public class UndertowServerAddJsp
extends UndertowServer {
    public UndertowServerAddJsp(HttpServerProps props) {
        super(props);
    }

    @Override
    protected HttpHandler buildHandler() throws Exception {
        DeploymentInfo builder = this.initDeploymentInfo();
        String resRoot = this.getResourceRoot();
        builder.setResourceManager((ResourceManager)new JspResourceManager((ClassLoader)AppClassLoader.global(), resRoot));
        builder.addServlet(new ServletInfo("ACTServlet", UtHttpContextServletHandler.class).addMapping("/").setAsyncSupported(true)).addServlet(JspServletEx.createServlet("JSPServlet", "*.jsp"));
        UndertowServerAddJsp.setupDeployment(builder, (InstanceManager)new SimpleInstanceManager());
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        return manager.start();
    }

    private static void setupDeployment(DeploymentInfo deploymentInfo, InstanceManager instanceManager) {
        deploymentInfo.addServletContextAttribute(InstanceManager.class.getName(), (Object)instanceManager);
        deploymentInfo.addServletContainerInitializers(new ServletContainerInitializerInfo[]{new ServletContainerInitializerInfo(JasperInitializer.class, Collections.emptySet())});
    }

    protected String getResourceRoot() throws FileNotFoundException {
        File dir;
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            if (NativeDetector.inNativeImage()) {
                return "";
            }
            throw new FileNotFoundException("Unable to find root");
        }
        if (Solon.cfg().isDebugMode() && Solon.cfg().isFilesMode() && (dir = DebugUtils.getDebugLocation((ClassLoader)AppClassLoader.global(), (String)"/")) != null) {
            return dir.toURI().getPath();
        }
        return rootURL.getPath();
    }

    protected URL getRootPath() {
        URL root = ResourceUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            URL temp = ResourceUtil.getResource((String)"");
            if (temp == null) {
                return null;
            }
            String path = temp.toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

