/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.apache.catalina.Context;
import org.apache.catalina.startup.Tomcat;
import org.noear.solon.Utils;
import org.noear.solon.lang.Nullable;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.http.HttpServerConfigure;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.ssl.SslConfig;
import org.noear.solon.server.tomcat.websocket.TcWebSocketManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TomcatServerBase
implements ServerLifecycle,
HttpServerConfigure {
    static final Logger log = LoggerFactory.getLogger(TomcatServerBase.class);
    protected Tomcat _server;
    protected final HttpServerProps props;
    protected SslConfig sslConfig = new SslConfig("http");
    protected Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();
    protected boolean enableHttp2 = false;

    public TomcatServerBase(HttpServerProps props) {
        this.props = props;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public boolean isSupportedHttp2() {
        return true;
    }

    public void enableHttp2(boolean enable) {
        this.enableHttp2 = enable;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public void setExecutor(Executor executor) {
        log.warn("Tomcat does not support user-defined executor");
    }

    public HttpServerProps getProps() {
        return this.props;
    }

    public void start(String host, int port) throws Throwable {
        this._server = new Tomcat();
        if (Utils.isNotEmpty((String)host)) {
            this._server.setHostname(host);
        }
        Context _context = this.initContext();
        this.addConnector(port, true);
        for (Integer portAdd : this.addHttpPorts) {
            this.addConnector(portAdd, false);
        }
        this._server.start();
        if (TcWebSocketManager.isEnableWebSocket()) {
            TcWebSocketManager.registerEndpoints(_context);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected abstract Context initContext() throws IOException;

    protected abstract void addConnector(int var1, boolean var2) throws IOException;
}

