/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.jasper.servlet.JspServlet;
import org.apache.tomcat.util.descriptor.web.JspConfigDescriptorImpl;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.tomcat.TomcatServer;
import org.noear.solon.server.tomcat.jsp.JspTldLocator;
import org.noear.solon.server.util.DebugUtils;

public class TomcatServerJsp
extends TomcatServer {
    public TomcatServerJsp(HttpServerProps props) {
        super(props);
    }

    @Override
    protected Context initContext() {
        Context ctx = super.initContext();
        try {
            String resRoot = this.getResourceRoot();
            ctx.setDocBase(resRoot);
            this.addJspSupport(ctx);
            this.addTldSupport(ctx);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return ctx;
    }

    private void addJspSupport(Context context) throws IOException {
        Wrapper jspServlet = Tomcat.addServlet((Context)context, (String)"jsp", (Servlet)new JspServlet());
        jspServlet.addInitParameter("fork", "false");
        jspServlet.addInitParameter("xpoweredBy", "false");
        if (Solon.cfg().isDebugMode()) {
            jspServlet.addInitParameter("development", "true");
        }
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
        JasperInitializer jasperInstance = new JasperInitializer();
        context.addServletContainerInitializer((ServletContainerInitializer)jasperInstance, null);
    }

    private void addTldSupport(Context ctx) throws IOException {
        Map<String, TaglibDescriptor> tagLibInfos = JspTldLocator.createTldInfos("WEB-INF", "templates");
        if (tagLibInfos.size() > 0) {
            ArrayList<TaglibDescriptor> taglibs = new ArrayList<TaglibDescriptor>(tagLibInfos.values());
            JspConfigDescriptorImpl jspConfigDescriptor = new JspConfigDescriptorImpl(new ArrayList(), taglibs);
            ctx.setJspConfigDescriptor((JspConfigDescriptor)jspConfigDescriptor);
        }
    }

    private String getResourceRoot() throws FileNotFoundException {
        File dir;
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            if (NativeDetector.inNativeImage()) {
                return "";
            }
            throw new FileNotFoundException("Unable to find root");
        }
        if (Solon.cfg().isDebugMode() && Solon.cfg().isFilesMode() && (dir = DebugUtils.getDebugLocation((ClassLoader)AppClassLoader.global(), (String)"/")) != null) {
            return dir.toURI().getPath();
        }
        return rootURL.getPath();
    }

    private URL getRootPath() {
        URL root = ResourceUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            URL temp = ResourceUtil.getResource((String)"");
            if (temp == null) {
                return null;
            }
            String path = temp.toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

