/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.grizzly.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.AsyncContextState;
import org.noear.solon.server.handle.ContextBase;
import org.noear.solon.server.io.LimitedInputStream;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.util.RedirectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyHttpContext
extends ContextBase {
    static final Logger log = LoggerFactory.getLogger(GyHttpContext.class);
    private final Request _request;
    private final Response _response;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private String queryString;
    private LimitedInputStream _inputStream;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private int _status = 200;
    private boolean _headers_sent = false;
    private boolean _allows_write = true;
    protected final AsyncContextState asyncState = new AsyncContextState();

    public GyHttpContext(Request request, Response response) {
        this._request = request;
        this._response = response;
    }

    protected Request innerGetRequest() {
        return this._request;
    }

    protected Response innerGetResponse() {
        return this._response;
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            DecodeUtils.decodeMultipart((Context)this, (InputStream)this._request.getInputStream(), (MultiMap)this._fileMap);
        }
    }

    public boolean isHeadersSent() {
        return this._headers_sent;
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.getRemoteAddr();
    }

    public int remotePort() {
        return this._request.getRemotePort();
    }

    public int localPort() {
        return this._request.getLocalPort();
    }

    public String method() {
        return this._request.getMethod().getMethodString();
    }

    public String protocol() {
        return this._request.getProtocol().getProtocolString();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = this.parseURI(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL().toString();
        }
        return this._url;
    }

    public long contentLength() {
        return this._request.getContentLength();
    }

    public String queryString() {
        try {
            if (this.queryString == null) {
                this.queryString = this._request.getQueryString();
                this.queryString = this.queryString == null ? "" : ServerProps.urlDecode((String)this.queryString);
            }
            return this.queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw DecodeUtils.status4xx((Context)this, (Exception)e);
        }
    }

    public InputStream bodyAsStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new LimitedInputStream(this._request.getInputStream(), ServerProps.request_maxBodySize);
        }
        return this._inputStream;
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                DecodeUtils.decodeFormUrlencoded((Context)this);
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry entry : this._request.getParameterMap().entrySet()) {
                    String key = ServerProps.urlDecode((String)((String)entry.getKey()));
                    this._paramMap.holder(key).setValues((Object[])entry.getValue());
                }
            }
            catch (Exception e) {
                throw DecodeUtils.status4xx((Context)this, (Exception)e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap(false);
            DecodeUtils.decodeCookies((Context)this, (String)this.header("Cookie"));
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            for (String k : this._request.getHeaderNames()) {
                for (String v : this._request.getHeaders(k)) {
                    this._headerMap.holder(k).addValue((Object)v);
                }
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType != null && contentType.length() > 0 && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        return this._response.getOutputStream();
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.getHeader(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return Arrays.asList(this._response.getHeaderValues(name));
    }

    public Collection<String> headerNamesOfResponse() {
        return Arrays.asList(this._response.getHeaderNames());
    }

    public void cookieSet(Cookie cookie) {
        org.glassfish.grizzly.http.Cookie c = new org.glassfish.grizzly.http.Cookie(cookie.name, cookie.value);
        if (cookie.maxAge >= 0) {
            c.setMaxAge(cookie.maxAge);
        }
        if (Utils.isNotEmpty((String)cookie.domain)) {
            c.setDomain(cookie.domain);
        }
        if (Utils.isNotEmpty((String)cookie.path)) {
            c.setPath(cookie.path);
        }
        c.setSecure(cookie.secure);
        c.setHttpOnly(cookie.httpOnly);
        this._response.addCookie(c);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void contentLength(long size) {
        this._response.setContentLengthLong(size);
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this._response.flush();
        }
    }

    public void close() throws IOException {
        this._response.finish();
    }

    protected void innerCommit() throws IOException {
        try {
            if (this.getHandled() || this.status() >= 200) {
                this.sendHeaders(true);
            } else {
                this.status(404);
                this.sendHeaders(true);
            }
        }
        finally {
            if (this.asyncState.asyncFuture != null) {
                this.asyncState.asyncFuture.complete(null);
            } else {
                this._response.finish();
            }
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            this._response.setStatus(this.status());
            if (isCommit || !this._allows_write) {
                this._response.setContentLength(0);
            }
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public boolean asyncStarted() {
        return this.asyncState.isStarted;
    }

    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    public void asyncStart(long timeout, Runnable runnable) {
        if (!this.asyncState.isStarted) {
            this.asyncState.isStarted = true;
            this._response.suspend();
            this.asyncState.asyncFuture = new CompletableFuture();
            this.asyncState.asyncDelay(timeout, (Context)this, this::innerCommit);
            this.asyncState.asyncFuture.whenComplete((result, error) -> this._response.resume());
            if (runnable != null) {
                runnable.run();
            }
            this.asyncState.onStart((Context)this);
        }
    }

    public void asyncComplete() {
        if (this.asyncState.isStarted) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError((Context)this, e);
            }
            finally {
                this.asyncState.onComplete((Context)this);
            }
        }
    }
}

