/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.grizzly;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.NamedThreadFactory;
import org.noear.solon.lang.Nullable;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.grizzly.http.GyHttpContextHandler;
import org.noear.solon.server.grizzly.util.ProvidedUtil;
import org.noear.solon.server.http.HttpServerConfigure;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.ssl.SslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyHttpServer
implements HttpServerConfigure,
ServerLifecycle {
    static final Logger log = LoggerFactory.getLogger(GyHttpServer.class);
    private HttpServer _server;
    private final HttpServerProps props;
    private final SslConfig sslConfig = new SslConfig("http");
    private Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();
    private boolean enableHttp2 = false;
    private boolean isSecure;
    private boolean enableWebSocket;
    private Handler handler;

    public GyHttpServer(HttpServerProps props) {
        this.props = props;
    }

    public HttpServerProps getProps() {
        return this.props;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public boolean isSupportedHttp2() {
        return true;
    }

    public void enableHttp2(boolean enable) {
        this.enableHttp2 = enable;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public void setExecutor(Executor executor) {
        log.warn("Grizzly does not support user-defined executor");
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void start(String host, int port) throws Throwable {
        this.setup(host, port);
        this._server.start();
    }

    protected void setup(String host, int port) throws Throwable {
        if (Assert.isEmpty((String)host)) {
            host = "0.0.0.0";
        }
        this._server = new HttpServer();
        this.doAddHetworkListener(host, port, true);
        for (Integer portAdd : this.addHttpPorts) {
            this.doAddHetworkListener(host, portAdd, false);
        }
        if (this.enableWebSocket) {
            ProvidedUtil.doAddWsApp();
        }
        this._server.getServerConfiguration().addHttpHandler((HttpHandler)new GyHttpContextHandler(this.handler));
        this._server.getServerConfiguration().setAllowPayloadForUndefinedHttpMethods(true);
    }

    protected void doAddHetworkListener(String host, int port, boolean isMain) throws IOException {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Grizzly-Worker-").daemon(false);
        ThreadPoolConfig threadPoolConfig = ThreadPoolConfig.defaultConfig();
        threadPoolConfig.setThreadFactory((ThreadFactory)threadFactory);
        NetworkListener listener = new NetworkListener("port-" + port, host, port);
        listener.getTransport().setWorkerThreadPoolConfig(threadPoolConfig);
        if (isMain) {
            if (this.sslConfig.isSslEnable()) {
                this.isSecure = true;
                listener.setSecure(true);
                listener.setSSLEngineConfig(new SSLEngineConfigurator(this.sslConfig.getSslContext()).setClientMode(false).setNeedClientAuth(false));
            }
            if (this.enableHttp2) {
                ProvidedUtil.doAddOnH2(listener);
            }
            if (this.enableWebSocket) {
                ProvidedUtil.onAddOnWs(listener);
            }
        }
        if (ServerProps.request_maxBodySize > 0L) {
            if (ServerProps.request_maxBodySize > Integer.MAX_VALUE) {
                listener.setMaxFormPostSize(Integer.MAX_VALUE);
            } else {
                listener.setMaxFormPostSize((int)ServerProps.request_maxBodySize);
            }
        }
        if (ServerProps.request_maxHeaderSize > 0) {
            listener.setMaxHttpHeaderSize(ServerProps.request_maxHeaderSize);
        }
        this._server.addListener(listener);
    }

    public void stop() throws Throwable {
        this._server.shutdownNow();
    }
}

