/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.SerializationConfig;

public class StringSerializerRender
implements Render {
    private transient boolean typed;
    private transient ContextSerializer<String> serializer;

    public StringSerializerRender(boolean typed, ContextSerializer<String> serializer) {
        this.typed = typed;
        this.serializer = serializer;
    }

    public boolean isTyped() {
        return this.typed;
    }

    public Serializer<String> getSerializer() {
        return this.serializer;
    }

    public String name() {
        return this.getClass().getSimpleName() + "#" + this.serializer.name();
    }

    public boolean matched(Context ctx, String accept) {
        if (this.typed) {
            return false;
        }
        return this.serializer.matched(ctx, accept);
    }

    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        return (String)this.serializer.serialize(data);
    }

    public void render(Object data, Context ctx) throws Throwable {
        if (SerializationConfig.isOutputMeta()) {
            ctx.headerAdd("solon.serialization", this.name());
        }
        String text = null;
        if (this.typed) {
            text = (String)this.serializer.serialize(data);
        } else {
            if (data == null) {
                return;
            }
            if (data instanceof Throwable) {
                throw (Throwable)data;
            }
            text = data instanceof String ? (String)data : (String)this.serializer.serialize(data);
        }
        ctx.attrSet("output", (Object)text);
        this.output(ctx, data, text);
    }

    protected void output(Context ctx, Object data, String text) {
        if (data instanceof String && !this.isTyped()) {
            ctx.output(text);
        } else {
            if (ctx.contentTypeNew() == null) {
                ctx.contentType(this.serializer.mimeType());
            }
            ctx.output(text);
        }
    }
}

