/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class ProtostuffBytesSerializer
implements ContextSerializer<byte[]> {
    private static final String label = "application/protobuf";
    private static final ProtostuffBytesSerializer instance = new ProtostuffBytesSerializer();

    public static ProtostuffBytesSerializer getInstance() {
        return instance;
    }

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    public boolean bodyRequired() {
        return true;
    }

    public String name() {
        return "protostuff-bytes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object obj) throws IOException {
        if (obj == null) {
            return new byte[0];
        }
        LinkedBuffer buffer = LinkedBuffer.allocate();
        try {
            Schema schema = RuntimeSchema.getSchema(obj.getClass());
            byte[] byArray = ProtostuffIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    public Object deserialize(byte[] data, Type toType) throws IOException {
        if (toType instanceof Class) {
            Schema schema = RuntimeSchema.getSchema((Class)((Class)toType));
            Object tmp = schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)tmp, (Schema)schema);
            return tmp;
        }
        throw new IllegalStateException("The parameter 'toType' is not Class");
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        return this.deserialize(ctx.bodyAsBytes(), bodyType);
    }
}

