/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.properties;

import java.util.Collection;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.properties.PropertiesStringSerializer;

public class PropertiesActionExecutor
extends ActionExecuteHandlerDefault {
    private PropertiesStringSerializer serializer = new PropertiesStringSerializer();
    private boolean allowGet = true;
    private boolean allowPostForm = false;

    public PropertiesActionExecutor() {
        this.serializer.getConfig().add(new Feature[]{Feature.DisableClassNameRead});
    }

    public void allowGet(boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void allowPostForm(boolean allowPostForm) {
        this.allowPostForm = allowPostForm;
    }

    public Options config() {
        return this.serializer.getConfig();
    }

    public boolean matched(Context ctx, String mime) {
        if (this.allowGet && MethodType.GET.name.equals(ctx.method()) || this.allowPostForm && (ctx.isFormUrlencoded() || ctx.isMultipartFormData())) {
            for (String key : ctx.paramMap().keySet()) {
                if (key.indexOf(46) <= 0 && key.indexOf(91) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.isRequiredPath() || p.isRequiredCookie() || p.isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.isRequiredBody() && ctx.paramMap().containsKey(p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        ONode tmp = (ONode)bodyObj;
        if (tmp.isObject()) {
            if (!p.isRequiredBody() && tmp.contains(p.getName())) {
                if (p.isGenericType()) {
                    return tmp.get(p.getName()).toObject(p.getGenericType());
                }
                return tmp.get(p.getName()).toObject(pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.toObject(p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.toObject(p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        return tmp.val().getRaw();
    }
}

