/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.jackson.JacksonDecl;
import org.noear.solon.serialization.jackson.impl.NullValueSerializerImpl;
import org.noear.solon.serialization.jackson.impl.TypeReferenceImpl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;

public class JacksonStringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final JacksonStringSerializer _default = new JacksonStringSerializer();
    private JacksonDecl<SerializationFeature> serializeConfig;
    private JacksonDecl<DeserializationFeature> deserializeConfig;
    private AtomicBoolean initStatus = new AtomicBoolean(false);

    public static JacksonStringSerializer getDefault() {
        return _default;
    }

    public JacksonStringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public JacksonStringSerializer() {
    }

    public JacksonDecl<SerializationFeature> getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new JacksonDecl();
        }
        return this.serializeConfig;
    }

    public JacksonDecl<DeserializationFeature> getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new JacksonDecl();
        }
        return this.deserializeConfig;
    }

    public void refresh() {
        this.initStatus.set(false);
    }

    protected void init() {
        if (this.initStatus.compareAndSet(false, true)) {
            this.getSerializeConfig().refresh();
            this.getDeserializeConfig().refresh();
        }
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "jackson-json";
    }

    public String serialize(Object obj) throws IOException {
        this.init();
        return this.getSerializeConfig().getMapper().writeValueAsString(obj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        this.init();
        if (toType == null) {
            return this.getDeserializeConfig().getMapper().readTree(data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        TypeReferenceImpl typeRef = new TypeReferenceImpl(toType);
        return this.getDeserializeConfig().getMapper().readValue(data, typeRef);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        this.init();
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        this.init();
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getDeserializeConfig().getMapper().readTree(data);
        }
        return null;
    }

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.getSerializeConfig().getCustomModule().addSerializer(clz, encoder);
    }

    public <T> void addEncoder(final Class<T> clz, final Converter<T, Object> converter) {
        if (clz == Date.class) {
            this.addEncoder((Class<T>)Date.class, (JsonSerializer<T>)new DateSerializer(){

                public void serialize(Date date, JsonGenerator out, SerializerProvider sp) throws IOException {
                    if (this._customFormat == null) {
                        JacksonStringSerializer.writeDefaultValue(converter, clz.cast(date), out);
                    } else {
                        super.serialize(date, out, sp);
                    }
                }
            });
        } else {
            this.addEncoder(clz, new JsonSerializer<T>(){

                public void serialize(T source, JsonGenerator out, SerializerProvider sp) throws IOException {
                    JacksonStringSerializer.writeDefaultValue(converter, source, out);
                }
            });
        }
    }

    private static <T> void writeDefaultValue(Converter<T, Object> converter, T source, JsonGenerator out) throws IOException {
        Object val = converter.convert(source);
        if (val == null) {
            out.writeNull();
        } else if (val instanceof String) {
            out.writeString((String)val);
        } else if (val instanceof Number) {
            if (val instanceof Integer || val instanceof Long) {
                out.writeNumber(((Number)val).longValue());
            } else {
                out.writeNumber(((Number)val).doubleValue());
            }
        } else {
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        }
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        boolean writeNulls = false;
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                this.getSerializeConfig().getMapper().getSerializerProvider().setNullValueSerializer((JsonSerializer)new NullValueSerializerImpl(jsonProps));
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().getMapper().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            }
        }
        if (!writeNulls) {
            this.getSerializeConfig().getMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        this.getSerializeConfig().getMapper().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        this.getSerializeConfig().getMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.getSerializeConfig().getMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.getSerializeConfig().getMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.getSerializeConfig().getMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        this.getSerializeConfig().getMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.getSerializeConfig().getMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.getSerializeConfig().getMapper().configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }
}

