/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.jackson.JacksonStringSerializer;
import org.noear.solon.serialization.jackson.impl.TimeDeserializer;
import org.noear.solon.serialization.jackson.impl.TypeReferenceImpl;

public class JacksonEntityConverter
extends AbstractStringEntityConverter<JacksonStringSerializer> {
    public JacksonEntityConverter(JacksonStringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getDeserializeConfig().setMapper(this.newMapper(new Module[]{new JavaTimeModule()}));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(LocalDateTime.class, new TimeDeserializer<LocalDateTime>(LocalDateTime.class));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(LocalDate.class, new TimeDeserializer<LocalDate>(LocalDate.class));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(LocalTime.class, new TimeDeserializer<LocalTime>(LocalTime.class));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(Date.class, new TimeDeserializer<Date>(Date.class));
        serializer.getSerializeConfig().addFeatures((ConfigFeature[])new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        serializer.getSerializeConfig().getMapper().registerModule((Module)new JavaTimeModule());
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    public ObjectMapper newMapper(Module ... modules) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTypingAsProperty(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        mapper.registerModules(modules);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return mapper;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((JacksonStringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        JsonNode tmp = (JsonNode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.has(p.spec().getName())) {
                JsonNode m1 = tmp.get(p.spec().getName());
                return ((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)m1), new TypeReferenceImpl(p));
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            return ((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            return ((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isValueNode()) {
            return ((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        return null;
    }
}

