/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.jackson.JacksonStringSerializer;
import org.noear.solon.serialization.jackson.impl.TimeDeserializer;
import org.noear.solon.serialization.jackson.impl.TypeReferenceImpl;

public class JacksonActionExecutor
extends ActionExecuteHandlerDefault {
    private JacksonStringSerializer serializer = new JacksonStringSerializer();

    public JacksonStringSerializer getSerializer() {
        return this.serializer;
    }

    public ObjectMapper config() {
        return this.serializer.getConfig();
    }

    public void config(ObjectMapper objectMapper) {
        this.serializer.setConfig(objectMapper);
    }

    public <T> void addDeserializer(Class<T> clz, JsonDeserializer<? extends T> deser) {
        this.serializer.getCustomModule().addDeserializer(clz, deser);
    }

    public JacksonActionExecutor() {
        this.config(this.newMapper(new Module[]{new JavaTimeModule()}));
        this.addDeserializer(LocalDateTime.class, new TimeDeserializer<LocalDateTime>(LocalDateTime.class));
        this.addDeserializer(LocalDate.class, new TimeDeserializer<LocalDate>(LocalDate.class));
        this.addDeserializer(LocalTime.class, new TimeDeserializer<LocalTime>(LocalTime.class));
        this.addDeserializer(Date.class, new TimeDeserializer<Date>(Date.class));
    }

    public ObjectMapper newMapper(Module ... modules) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTypingAsProperty(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        mapper.registerModules(modules);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return mapper;
    }

    public boolean matched(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        JsonNode tmp = (JsonNode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.has(p.spec().getName())) {
                JsonNode m1 = tmp.get(p.spec().getName());
                return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)m1), new TypeReferenceImpl(p));
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isValueNode()) {
            return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        return null;
    }
}

