/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.jackson.xml.JacksonXmlDecl;
import org.noear.solon.serialization.jackson.xml.impl.NullBeanSerializerModifierImpl;
import org.noear.solon.serialization.jackson.xml.impl.TypeReferenceImpl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;

public class JacksonXmlStringSerializer
implements EntityStringSerializer {
    public static final String label = "/xml";
    private static final JacksonXmlStringSerializer _default = new JacksonXmlStringSerializer();
    private JacksonXmlDecl<SerializationFeature> serializeConfig;
    private JacksonXmlDecl<DeserializationFeature> deserializeConfig;
    private AtomicBoolean initStatus = new AtomicBoolean(false);

    public static JacksonXmlStringSerializer getDefault() {
        return _default;
    }

    public JacksonXmlStringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public JacksonXmlStringSerializer() {
    }

    public JacksonXmlDecl<SerializationFeature> getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new JacksonXmlDecl();
        }
        return this.serializeConfig;
    }

    public JacksonXmlDecl<DeserializationFeature> getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new JacksonXmlDecl();
        }
        return this.deserializeConfig;
    }

    protected void init() {
        if (this.initStatus.compareAndSet(false, true)) {
            this.getSerializeConfig().refresh();
            this.getDeserializeConfig().refresh();
        }
    }

    public String mimeType() {
        return "text/xml";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label);
    }

    public String name() {
        return "jackson-xml";
    }

    public String serialize(Object obj) throws IOException {
        this.init();
        return this.getSerializeConfig().getMapper().writeValueAsString(obj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        this.init();
        if (toType == null) {
            return this.getDeserializeConfig().getMapper().readTree(data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        TypeReferenceImpl typeRef = new TypeReferenceImpl(toType);
        return this.getDeserializeConfig().getMapper().readValue(data, typeRef);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        this.init();
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        this.init();
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getDeserializeConfig().getMapper().readTree(data);
        }
        return null;
    }

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.getSerializeConfig().getCustomModule().addSerializer(clz, encoder);
    }

    public <T> void addEncoder(final Class<T> clz, final Converter<T, Object> converter) {
        if (clz == Date.class) {
            this.addEncoder((Class<T>)Date.class, (JsonSerializer<T>)new DateSerializer(){

                public void serialize(Date date, JsonGenerator out, SerializerProvider sp) throws IOException {
                    if (this._customFormat == null) {
                        JacksonXmlStringSerializer.writeDefaultValue(converter, clz.cast(date), out);
                    } else {
                        super.serialize(date, out, sp);
                    }
                }
            });
        } else {
            this.addEncoder(clz, new JsonSerializer<T>(){

                public void serialize(T source, JsonGenerator out, SerializerProvider sp) throws IOException {
                    JacksonXmlStringSerializer.writeDefaultValue(converter, source, out);
                }
            });
        }
    }

    private static <T> void writeDefaultValue(Converter<T, Object> converter, T source, JsonGenerator out) throws IOException {
        Object val = converter.convert(source);
        if (val == null) {
            out.writeNull();
        } else if (val instanceof String) {
            out.writeString((String)val);
        } else if (val instanceof Number) {
            if (val instanceof Integer || val instanceof Long) {
                out.writeNumber(((Number)val).longValue());
            } else {
                out.writeNumber(((Number)val).doubleValue());
            }
        } else {
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        }
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        boolean writeNulls = false;
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                SerializerFactory serializerFactory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new NullBeanSerializerModifierImpl(jsonProps));
                this.getSerializeConfig().getMapper().setSerializerFactory(serializerFactory);
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().getMapper().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            }
        }
        if (!writeNulls) {
            this.getSerializeConfig().getMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        this.getSerializeConfig().getMapper().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        this.getSerializeConfig().getMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.getSerializeConfig().getMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.getSerializeConfig().getMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.getSerializeConfig().getMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        this.getSerializeConfig().getMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.getSerializeConfig().getMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.getSerializeConfig().getMapper().configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }
}

