/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Arrays;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.jackson.xml.JacksonXmlRenderFactoryBase;
import org.noear.solon.serialization.jackson.xml.impl.NullBeanSerializerModifierImpl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class JacksonXmlRenderFactory
extends JacksonXmlRenderFactoryBase {
    public JacksonXmlRenderFactory(JsonProps jsonProps) {
        this.serializer.getCustomFeatures().add(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.serializer.getConfig().registerModule((Module)new JavaTimeModule());
        this.applyProps(jsonProps);
    }

    public String[] mappings() {
        return new String[]{"@xml"};
    }

    public Render create() {
        return new StringSerializerRender(false, (ContextSerializer)this.serializer);
    }

    public void setFeatures(SerializationFeature ... features) {
        this.serializer.getCustomFeatures().clear();
        this.serializer.getCustomFeatures().addAll(Arrays.asList(features));
    }

    public void addFeatures(SerializationFeature ... features) {
        this.serializer.getCustomFeatures().addAll(Arrays.asList(features));
    }

    public void removeFeatures(SerializationFeature ... features) {
        this.serializer.getCustomFeatures().removeAll(Arrays.asList(features));
    }

    protected void applyProps(JsonProps jsonProps) {
        boolean writeNulls = false;
        if (jsonProps != null) {
            JsonPropsUtil.dateAsFormat((JsonRenderFactory)this, (JsonProps)jsonProps);
            JsonPropsUtil.dateAsTicks((JsonRenderFactory)this, (JsonProps)jsonProps);
            JsonPropsUtil.boolAsInt((JsonRenderFactory)this, (JsonProps)jsonProps);
            JsonPropsUtil.longAsString((JsonRenderFactory)this, (JsonProps)jsonProps);
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                SerializerFactory serializerFactory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new NullBeanSerializerModifierImpl(jsonProps));
                this.config().setSerializerFactory(serializerFactory);
            }
            if (jsonProps.enumAsName) {
                this.config().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            }
        }
        if (!writeNulls) {
            this.config().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        this.config().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        this.config().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.config().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.config().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.config().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        this.config().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.config().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.config().configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }
}

