/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.jackson.xml.impl.TypeReferenceImpl;

public class JacksonXmlStringSerializer
implements ContextSerializer<String> {
    public static final String label = "/xml";
    private XmlMapper config;
    private Set<SerializationFeature> configFeatures;
    private SimpleModule configModule;
    private AtomicBoolean initStatus = new AtomicBoolean(false);

    public Set<SerializationFeature> getCustomFeatures() {
        if (this.configFeatures == null) {
            this.configFeatures = new HashSet<SerializationFeature>();
        }
        return this.configFeatures;
    }

    public SimpleModule getCustomModule() {
        if (this.configModule == null) {
            this.configModule = new SimpleModule();
        }
        return this.configModule;
    }

    public XmlMapper getConfig() {
        if (this.config == null) {
            this.config = new XmlMapper();
        }
        return this.config;
    }

    public void setConfig(XmlMapper config) {
        if (config != null) {
            this.config = config;
        }
    }

    protected void init() {
        if (this.initStatus.compareAndSet(false, true)) {
            if (this.configFeatures != null) {
                for (SerializationFeature f1 : this.configFeatures) {
                    this.getConfig().enable(f1);
                }
            }
            if (this.configModule != null) {
                this.getConfig().registerModule((Module)this.configModule);
            }
        }
    }

    public String mimeType() {
        return "text/xml";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label);
    }

    public String name() {
        return "jackson-xml";
    }

    public String serialize(Object obj) throws IOException {
        this.init();
        return this.getConfig().writeValueAsString(obj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        this.init();
        if (toType == null) {
            return this.getConfig().readTree(data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        TypeReferenceImpl typeRef = new TypeReferenceImpl(toType);
        return this.getConfig().readValue(data, typeRef);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        this.init();
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        this.init();
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getConfig().readTree(data);
        }
        return null;
    }
}

