/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.gson.GsonStringSerializer;
import org.noear.solon.serialization.gson.impl.DateReadAdapter;

public class GsonActionExecutor
extends ActionExecuteHandlerDefault {
    private final GsonStringSerializer serializer = new GsonStringSerializer();

    public GsonActionExecutor() {
        this.serializer.getConfig().registerTypeAdapter(Date.class, (Object)new DateReadAdapter());
    }

    public GsonStringSerializer getSerializer() {
        return this.serializer;
    }

    public GsonBuilder config() {
        return this.getSerializer().getConfig();
    }

    public boolean matched(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JsonObject) {
            JsonObject tmp = (JsonObject)bodyObj;
            if (!p.spec().isRequiredBody() && tmp.has(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return this.serializer.getGson().fromJson(tmp.get(p.spec().getName()), (Type)p.getGenericType());
                }
                return this.serializer.getGson().fromJson(tmp.get(p.spec().getName()), pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return this.serializer.getGson().fromJson((JsonElement)tmp, (Type)p.getGenericType());
            }
            return this.serializer.getGson().fromJson((JsonElement)tmp, pt);
        }
        if (bodyObj instanceof JsonArray) {
            JsonArray tmp = (JsonArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return this.serializer.getGson().fromJson((JsonElement)tmp, (Type)p.getGenericType());
            }
            return this.serializer.getGson().fromJson((JsonElement)tmp, pt);
        }
        return bodyObj;
    }
}

