/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.fastjson2.Fastjson2StringSerializer;

public class Fastjson2EntityConverter
extends AbstractStringEntityConverter<Fastjson2StringSerializer> {
    public Fastjson2EntityConverter(Fastjson2StringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getDeserializeConfig().addFeatures((JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
        serializer.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((Fastjson2StringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (!p.spec().isRequiredBody() && tmp.containsKey(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.getObject(p.spec().getName(), (Type)p.getGenericType(), new JSONReader.Feature[0]);
                }
                return tmp.getObject(p.spec().getName(), pt, new JSONReader.Feature[0]);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.to((Type)p.getGenericType(), new JSONReader.Feature[0]);
            }
            return tmp.to(pt, new JSONReader.Feature[0]);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.to((Type)p.getGenericType());
            }
            return tmp.to(pt);
        }
        return bodyObj;
    }
}

