/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import org.noear.solon.core.util.Assert;

public class Fastjson2Decl<C, F> {
    private final boolean forSerialize;
    private C context;

    public Fastjson2Decl(C context) {
        this.context = context;
        this.forSerialize = context instanceof JSONWriter.Context;
    }

    public C getContext() {
        return this.context;
    }

    public void setContext(C context) {
        Assert.notNull(context, (String)"context can not be null");
        this.context = context;
    }

    public void setFeatures(F ... features) {
        if (this.forSerialize) {
            ((JSONWriter.Context)this.context).setFeatures(JSONFactory.getDefaultWriterFeatures());
        } else {
            ((JSONReader.Context)this.context).setFeatures(JSONFactory.getDefaultReaderFeatures());
        }
        this.addFeatures(features);
    }

    public void addFeatures(F ... features) {
        if (this.forSerialize) {
            for (F f1 : features) {
                JSONWriter.Feature feature = (JSONWriter.Feature)f1;
                ((JSONWriter.Context)this.context).config(feature, true);
            }
        } else {
            for (F f1 : features) {
                JSONReader.Feature feature = (JSONReader.Feature)f1;
                ((JSONReader.Context)this.context).config(feature, true);
            }
        }
    }

    public void removeFeatures(F ... features) {
        if (this.forSerialize) {
            for (F f1 : features) {
                JSONWriter.Feature feature = (JSONWriter.Feature)f1;
                ((JSONWriter.Context)this.context).config(feature, false);
            }
        } else {
            for (F f1 : features) {
                JSONReader.Feature feature = (JSONReader.Feature)f1;
                ((JSONReader.Context)this.context).config(feature, false);
            }
        }
    }
}

