/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.fastjson2.Fastjson2RenderFactoryBase;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class Fastjson2RenderFactory
extends Fastjson2RenderFactoryBase {
    public Fastjson2RenderFactory(JsonProps jsonProps) {
        this.serializer.cfgSerializeFeatures(false, true, JSONWriter.Feature.BrowserCompatible);
        this.applyProps(jsonProps);
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    public Render create() {
        return new StringSerializerRender(false, (ContextSerializer)this.serializer);
    }

    public void setFeatures(JSONWriter.Feature ... features) {
        this.serializer.cfgSerializeFeatures(true, true, features);
    }

    public void addFeatures(JSONWriter.Feature ... features) {
        this.serializer.cfgSerializeFeatures(false, true, features);
    }

    public void removeFeatures(JSONWriter.Feature ... features) {
        this.serializer.cfgSerializeFeatures(false, false, features);
    }

    protected void applyProps(JsonProps jsonProps) {
        if (jsonProps != null && jsonProps.dateAsTicks) {
            jsonProps.dateAsTicks = false;
            this.getSerializer().getSerializeConfig().setDateFormat("millis");
        }
        if (JsonPropsUtil.apply((JsonRenderFactory)this, (JsonProps)jsonProps)) {
            boolean writeNulls;
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (jsonProps.nullStringAsEmpty) {
                this.addFeatures(JSONWriter.Feature.WriteNullStringAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                this.addFeatures(JSONWriter.Feature.WriteNullBooleanAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                this.addFeatures(JSONWriter.Feature.WriteNullNumberAsZero);
            }
            if (jsonProps.boolAsInt) {
                this.addFeatures(JSONWriter.Feature.WriteBooleanAsNumber);
            }
            if (jsonProps.longAsString) {
                this.addFeatures(JSONWriter.Feature.WriteLongAsString);
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.addFeatures(JSONWriter.Feature.WriteNullListAsEmpty);
            }
            if (jsonProps.enumAsName) {
                this.addFeatures(JSONWriter.Feature.WriteEnumsUsingName);
            }
            if (writeNulls) {
                this.addFeatures(JSONWriter.Feature.WriteNulls);
            }
        }
    }
}

