/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.abc;

import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.abc.io.AbcSerializable;

public class AbcBytesSerializer
implements EntitySerializer<byte[]> {
    private static final String label = "application/abc";
    private static final AbcBytesSerializer _default = new AbcBytesSerializer();

    public static AbcBytesSerializer getDefault() {
        return _default;
    }

    @Deprecated
    public static AbcBytesSerializer getInstance() {
        return _default;
    }

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    public boolean bodyRequired() {
        return true;
    }

    public String name() {
        return "abc-bytes";
    }

    public byte[] serialize(Object fromObj) throws IOException {
        if (fromObj instanceof AbcSerializable) {
            AbcSerializable bs = (AbcSerializable)fromObj;
            Object out = bs.serializeFactory().createOutput();
            bs.serializeWrite(out);
            return bs.serializeFactory().extractBytes(out);
        }
        throw new IllegalStateException("The parameter 'fromObj' is not of AbcSerializable");
    }

    public Object deserialize(byte[] data, Type toType) throws IOException {
        if (toType instanceof Class) {
            if (AbcSerializable.class.isAssignableFrom((Class)toType)) {
                AbcSerializable tmp = (AbcSerializable)ClassUtil.newInstance((Class)((Class)toType));
                Object in = tmp.serializeFactory().createInput(data);
                tmp.serializeRead(in);
                return tmp;
            }
            throw new IllegalStateException("The parameter 'toType' is not of AbcSerializable");
        }
        throw new IllegalStateException("The parameter 'toType' is not Class");
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        return this.deserialize(ctx.bodyAsBytes(), bodyType);
    }
}

