/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.MethodEggg;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.EgggUtil;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.validation.BeanValidateInfo;
import org.noear.solon.validation.BeanValidator;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.ValidatorException;
import org.noear.solon.validation.ValidatorFailureHandler;
import org.noear.solon.validation.ValidatorFailureHandlerDefault;
import org.noear.solon.validation.annotation.AssertFalse;
import org.noear.solon.validation.annotation.AssertFalseValidator;
import org.noear.solon.validation.annotation.AssertTrue;
import org.noear.solon.validation.annotation.AssertTrueValidator;
import org.noear.solon.validation.annotation.Date;
import org.noear.solon.validation.annotation.DateValidator;
import org.noear.solon.validation.annotation.DecimalMax;
import org.noear.solon.validation.annotation.DecimalMaxValidator;
import org.noear.solon.validation.annotation.DecimalMin;
import org.noear.solon.validation.annotation.DecimalMinValidator;
import org.noear.solon.validation.annotation.Email;
import org.noear.solon.validation.annotation.EmailValidator;
import org.noear.solon.validation.annotation.Length;
import org.noear.solon.validation.annotation.LengthValidator;
import org.noear.solon.validation.annotation.Logined;
import org.noear.solon.validation.annotation.LoginedChecker;
import org.noear.solon.validation.annotation.LoginedValidator;
import org.noear.solon.validation.annotation.Max;
import org.noear.solon.validation.annotation.MaxValidator;
import org.noear.solon.validation.annotation.Min;
import org.noear.solon.validation.annotation.MinValidator;
import org.noear.solon.validation.annotation.NoRepeatSubmit;
import org.noear.solon.validation.annotation.NoRepeatSubmitChecker;
import org.noear.solon.validation.annotation.NoRepeatSubmitValidator;
import org.noear.solon.validation.annotation.NotBlacklist;
import org.noear.solon.validation.annotation.NotBlacklistChecker;
import org.noear.solon.validation.annotation.NotBlacklistValidator;
import org.noear.solon.validation.annotation.NotBlank;
import org.noear.solon.validation.annotation.NotBlankValidator;
import org.noear.solon.validation.annotation.NotEmpty;
import org.noear.solon.validation.annotation.NotEmptyValidator;
import org.noear.solon.validation.annotation.NotNull;
import org.noear.solon.validation.annotation.NotNullValidator;
import org.noear.solon.validation.annotation.NotZero;
import org.noear.solon.validation.annotation.NotZeroValidator;
import org.noear.solon.validation.annotation.Null;
import org.noear.solon.validation.annotation.NullValidator;
import org.noear.solon.validation.annotation.Numeric;
import org.noear.solon.validation.annotation.NumericValidator;
import org.noear.solon.validation.annotation.Pattern;
import org.noear.solon.validation.annotation.PatternValidator;
import org.noear.solon.validation.annotation.Range;
import org.noear.solon.validation.annotation.RangeValidator;
import org.noear.solon.validation.annotation.Size;
import org.noear.solon.validation.annotation.SizeValidator;
import org.noear.solon.validation.annotation.Validated;
import org.noear.solon.validation.annotation.ValidatedValidator;
import org.noear.solon.validation.annotation.Whitelist;
import org.noear.solon.validation.annotation.WhitelistChecker;
import org.noear.solon.validation.annotation.WhitelistValidator;
import org.noear.solon.validation.util.FormatUtils;

public class ValidatorManager {
    public static boolean VALIDATE_ALL = false;
    private static final Map<Class<? extends Annotation>, Validator> validMap = new HashMap<Class<? extends Annotation>, Validator>();
    private static ValidatorFailureHandler failureHandler = new ValidatorFailureHandlerDefault();

    public static void setNoRepeatSubmitChecker(NoRepeatSubmitChecker checker) {
        NoRepeatSubmitValidator.instance.setChecker(checker);
    }

    public static void setLoginedChecker(LoginedChecker checker) {
        LoginedValidator.instance.setChecker(checker);
    }

    public static void setWhitelistChecker(WhitelistChecker checker) {
        WhitelistValidator.instance.setChecker(checker);
    }

    public static void setNotBlacklistChecker(NotBlacklistChecker checker) {
        NotBlacklistValidator.instance.setChecker(checker);
    }

    public static void setBeanValidator(BeanValidator validator) {
        ValidatedValidator.instance.setValidator(validator);
    }

    public static void setFailureHandler(ValidatorFailureHandler handler) {
        if (handler != null) {
            failureHandler = handler;
        }
    }

    private static void initialize() {
        ValidatorManager.register(AssertTrue.class, AssertTrueValidator.instance);
        ValidatorManager.register(AssertFalse.class, AssertFalseValidator.instance);
        ValidatorManager.register(Date.class, DateValidator.instance);
        ValidatorManager.register(DecimalMax.class, DecimalMaxValidator.instance);
        ValidatorManager.register(DecimalMin.class, DecimalMinValidator.instance);
        ValidatorManager.register(Email.class, EmailValidator.instance);
        ValidatorManager.register(Max.class, MaxValidator.instance);
        ValidatorManager.register(Min.class, MinValidator.instance);
        ValidatorManager.register(NoRepeatSubmit.class, NoRepeatSubmitValidator.instance);
        ValidatorManager.register(NotBlank.class, NotBlankValidator.instance);
        ValidatorManager.register(NotEmpty.class, NotEmptyValidator.instance);
        ValidatorManager.register(NotNull.class, NotNullValidator.instance);
        ValidatorManager.register(NotZero.class, NotZeroValidator.instance);
        ValidatorManager.register(Null.class, NullValidator.instance);
        ValidatorManager.register(Numeric.class, NumericValidator.instance);
        ValidatorManager.register(Pattern.class, PatternValidator.instance);
        ValidatorManager.register(Length.class, LengthValidator.instance);
        ValidatorManager.register(Size.class, SizeValidator.instance);
        ValidatorManager.register(Range.class, RangeValidator.instance);
        ValidatorManager.register(Whitelist.class, WhitelistValidator.instance);
        ValidatorManager.register(Logined.class, LoginedValidator.instance);
        ValidatorManager.register(NotBlacklist.class, NotBlacklistValidator.instance);
        ValidatorManager.register(Validated.class, ValidatedValidator.instance);
    }

    public static void clear() {
        validMap.clear();
    }

    public static <T extends Annotation> void remove(Class<T> type) {
        validMap.remove(type);
    }

    public static <T extends Annotation> void register(Class<T> type, Validator<T> validator) {
        validMap.put(type, validator);
    }

    public static <T extends Annotation> Validator<T> get(Class<T> type) {
        return validMap.get(type);
    }

    public static void validateOfContext(Context ctx, Action action) throws Throwable {
        StringBuilder tmp = new StringBuilder();
        for (Annotation anno : action.controller().annotations()) {
            if (!ValidatorManager.validateOfContext0(ctx, anno, null, tmp)) continue;
            return;
        }
        for (Annotation anno : action.method().getAnnotations()) {
            if (!ValidatorManager.validateOfContext0(ctx, anno, null, tmp)) continue;
            return;
        }
    }

    private static boolean validateOfContext0(Context ctx, Annotation anno, String name, StringBuilder tmp) {
        if (ctx.getHandled()) {
            return true;
        }
        Validator valid = validMap.get(anno.annotationType());
        if (valid != null) {
            tmp.setLength(0);
            Result rst = valid.validateOfContext(ctx, anno, name, tmp);
            if (rst.getCode() != Result.SUCCEED_CODE && ValidatorManager.failureDo(ctx, anno, rst, valid.message(anno))) {
                return true;
            }
        }
        return false;
    }

    public static void validateOfInvocation(Invocation inv) throws Throwable {
        StringBuilder tmp = new StringBuilder();
        Result result = Result.succeed();
        result.setData(new ArrayList());
        int len = inv.args().length;
        for (int i = 0; i < len; ++i) {
            ParamWrap pw = inv.method().getParamWraps()[i];
            for (Annotation anno : pw.getParameter().getAnnotations()) {
                ValidatorManager.validateOfValue0(pw.spec().getName(), anno, inv.args()[i], (Result<List<BeanValidateInfo>>)result, tmp, inv, pw);
            }
        }
        if (result.getCode() != Result.SUCCEED_CODE) {
            tmp.setLength(0);
            for (BeanValidateInfo datum : (List)result.getData()) {
                tmp.append(datum.message).append("\uff1b");
            }
            if (tmp.length() > 0) {
                tmp.setLength(tmp.length() - 1);
            }
            result.setDescription(tmp.toString());
            throw new ValidatorException(result.getCode(), result.getDescription(), null, result);
        }
    }

    private static void validateOfValue0(String label, Annotation anno, Object val, Result<List<BeanValidateInfo>> result, StringBuilder tmp, Invocation inv, ParamWrap pw) {
        Validator valid = validMap.get(anno.annotationType());
        if (valid != null) {
            if (!valid.isSupportValueType(pw.getType())) {
                throw new IllegalStateException("@" + anno.annotationType().getSimpleName() + " not support the '" + pw.getName() + "' parameter as " + pw.getType().getSimpleName() + " type: " + inv.method().getMethod());
            }
            tmp.setLength(0);
            Result rst = valid.validateOfValue(anno, val, tmp);
            if (rst.getCode() == Result.FAILURE_CODE) {
                String message = null;
                if (Utils.isEmpty((String)rst.getDescription())) {
                    rst.setDescription(label);
                }
                if (rst.getData() instanceof BeanValidateInfo) {
                    BeanValidateInfo info = (BeanValidateInfo)((Object)rst.getData());
                    anno = info.anno;
                    message = info.message;
                    ((List)result.getData()).add(info);
                } else if (rst.getData() instanceof Collection) {
                    List list = (List)rst.getData();
                    ((List)result.getData()).addAll(list);
                } else {
                    BeanValidateInfo beanValidateInfo = new BeanValidateInfo(label, anno, valid.message(anno));
                    message = beanValidateInfo.message;
                    rst.setData((Object)beanValidateInfo);
                    ((List)result.getData()).add(beanValidateInfo);
                }
                if (VALIDATE_ALL) {
                    result.setCode(rst.getCode());
                } else {
                    if (ValidatorManager.failureDo(Context.current(), anno, rst, message)) {
                        throw new DataThrowable();
                    }
                    String msg = FormatUtils.format(anno, rst, message);
                    throw new ValidatorException(rst.getCode(), msg, null, rst);
                }
            }
        }
    }

    public static Result validateOfEntity(Object obj, Class<?>[] groups) {
        try {
            if (obj instanceof Collection) {
                return ValidatorManager.validateOfEntityAry(obj, groups);
            }
            if (obj instanceof Map) {
                return ValidatorManager.validateOfEntityMap(obj, groups);
            }
            return ValidatorManager.validateOfEntityOne(obj, groups);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Result validateOfEntityAry(Object obj, Class<?>[] groups) {
        for (Object val2 : (Collection)obj) {
            Result rst;
            if (val2 == null || (rst = ValidatorManager.validateOfEntity(val2, groups)).getCode() == Result.SUCCEED_CODE) continue;
            return rst;
        }
        return Result.succeed();
    }

    private static Result validateOfEntityMap(Object obj, Class<?>[] groups) {
        for (Object val2 : ((Map)obj).values()) {
            Result rst;
            if (val2 == null || (rst = ValidatorManager.validateOfEntity(val2, groups)).getCode() == Result.SUCCEED_CODE) continue;
            return rst;
        }
        return Result.succeed();
    }

    private static Result validateOfEntityOne(Object obj, Class<?>[] groups) throws IllegalAccessException {
        Validator<? extends Annotation> valid;
        if (obj == null) {
            return Result.succeed();
        }
        ClassEggg ce = EgggUtil.getClassEggg(obj.getClass());
        StringBuilder tmp = new StringBuilder();
        Result result = Result.succeed();
        ArrayList<BeanValidateInfo> list = new ArrayList<BeanValidateInfo>();
        for (FieldEggg fe : ce.getAllFieldEgggs()) {
            for (Annotation anno : fe.getAnnotations()) {
                valid = ValidatorManager.get(anno.annotationType());
                if (valid == null || !ValidatorManager.inGroup(valid.groups(anno), groups)) continue;
                if (!valid.isSupportValueType(fe.getType())) {
                    throw new IllegalStateException("@" + anno.annotationType().getSimpleName() + " not support the '" + fe.getName() + "' field as " + fe.getType().getSimpleName() + " type: " + ce.getType());
                }
                tmp.setLength(0);
                Result rst = valid.validateOfValue(anno, fe.getValue(obj, false), tmp);
                if (rst.getCode() == Result.SUCCEED_CODE) continue;
                if (Utils.isEmpty((String)rst.getDescription())) {
                    rst.setDescription(ce.getType().getSimpleName() + "." + fe.getName());
                }
                if (VALIDATE_ALL) {
                    result.setCode(rst.getCode());
                    if (rst.getData() instanceof BeanValidateInfo) {
                        list.add((BeanValidateInfo)((Object)rst.getData()));
                        continue;
                    }
                    if (rst.getData() instanceof Collection) {
                        List list2 = (List)rst.getData();
                        list.addAll(list2);
                        continue;
                    }
                    rst.setData((Object)new BeanValidateInfo(fe.getName(), anno, valid.message(anno)));
                    list.add((BeanValidateInfo)((Object)rst.getData()));
                    continue;
                }
                if (!(rst.getData() instanceof BeanValidateInfo)) {
                    rst.setData((Object)new BeanValidateInfo(fe.getName(), anno, valid.message(anno)));
                }
                return rst;
            }
        }
        for (MethodEggg me : ce.getPublicMethodEgggs()) {
            if (me.getParamCount() != 0) continue;
            for (Annotation anno : me.getAnnotations()) {
                valid = ValidatorManager.get(anno.annotationType());
                if (valid == null || !ValidatorManager.inGroup(valid.groups(anno), groups)) continue;
                if (!valid.isSupportValueType(me.getReturnType())) {
                    throw new IllegalStateException("@" + anno.annotationType().getSimpleName() + " not support the '" + me.getName() + "' method as " + me.getReturnType().getSimpleName() + " type: " + ce.getType());
                }
                tmp.setLength(0);
                Object methodValue = null;
                try {
                    methodValue = me.invoke(obj, new Object[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                Result rst = valid.validateOfValue(anno, methodValue, tmp);
                if (rst.getCode() == Result.SUCCEED_CODE) continue;
                if (Utils.isEmpty((String)rst.getDescription())) {
                    rst.setDescription(ce.getType().getSimpleName() + "." + me.getName() + "()");
                }
                if (VALIDATE_ALL) {
                    result.setCode(rst.getCode());
                    if (rst.getData() instanceof BeanValidateInfo) {
                        list.add((BeanValidateInfo)((Object)rst.getData()));
                        continue;
                    }
                    if (rst.getData() instanceof Collection) {
                        List list2 = (List)rst.getData();
                        list.addAll(list2);
                        continue;
                    }
                    rst.setData((Object)new BeanValidateInfo(me.getName() + "()", anno, valid.message(anno)));
                    list.add((BeanValidateInfo)((Object)rst.getData()));
                    continue;
                }
                if (!(rst.getData() instanceof BeanValidateInfo)) {
                    rst.setData((Object)new BeanValidateInfo(me.getName() + "()", anno, valid.message(anno)));
                }
                return rst;
            }
        }
        result.setData(list);
        return result;
    }

    public static boolean failureDo(Context ctx, Annotation ano, Result result, String message) {
        if (ctx == null) {
            return false;
        }
        try {
            return failureHandler.onFailure(ctx, ano, result, message);
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private static boolean inGroup(Class<?>[] annoGroups, Class<?>[] groups) {
        if (annoGroups == null || annoGroups.length == 0) {
            return true;
        }
        if (groups == null || groups.length == 0) {
            return false;
        }
        for (Class<?> g1 : groups) {
            for (Class<?> g2 : annoGroups) {
                if (g1 != g2) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ValidatorManager.initialize();
    }
}

