/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.DecimalMin;
import org.noear.solon.validation.util.StringUtils;

public class DecimalMinValidator
implements Validator<DecimalMin> {
    public static final DecimalMinValidator instance = new DecimalMinValidator();

    @Override
    public String message(DecimalMin anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(DecimalMin anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return ClassUtil.isNumberType(type);
    }

    @Override
    public Result validateOfValue(DecimalMin anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof Number)) {
            return Result.failure();
        }
        Number val = (Number)val0;
        if (!this.verify(anno, val)) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, DecimalMin anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (Utils.isEmpty((String)val)) {
            return Result.succeed();
        }
        if (!StringUtils.isNumber(val)) {
            return Result.failure((String)name);
        }
        if (!this.verify(anno, Double.parseDouble(val))) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(DecimalMin anno, Number val) {
        if (val == null) {
            return true;
        }
        return val.doubleValue() >= anno.value();
    }
}

