/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;

public class ExpressWebSocketListener
implements WebSocketListener {
    private WebSocketListener listener;
    private PathAnalyzer pathAnalyzer;
    private List<String> pathKeys;

    public ExpressWebSocketListener(String path, WebSocketListener listener) {
        this.listener = listener;
        if (path != null && path.indexOf("{") >= 0) {
            path = PathUtil.mergePath(null, (String)path);
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = PathAnalyzer.get((String)path);
            }
        }
    }

    public WebSocketListener getListener() {
        return this.listener;
    }

    @Override
    public void onOpen(WebSocket s) {
        Matcher pm;
        if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(s.path())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                s.param(this.pathKeys.get(i), pm.group(i + 1));
            }
        }
        this.listener.onOpen(s);
    }

    @Override
    public void onMessage(WebSocket s, String text) throws IOException {
        this.listener.onMessage(s, text);
    }

    @Override
    public void onMessage(WebSocket s, ByteBuffer binary) throws IOException {
        this.listener.onMessage(s, binary);
    }

    @Override
    public void onClose(WebSocket s) {
        this.listener.onClose(s);
    }

    @Override
    public void onError(WebSocket s, Throwable e) {
        this.listener.onError(s, e);
    }

    @Override
    public void onPing(WebSocket s) {
        this.listener.onPing(s);
    }

    @Override
    public void onPong(WebSocket s) {
        this.listener.onPong(s);
    }
}

