/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import org.noear.solon.Utils;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.stomp.Frame;

class SimpleFrame
implements Frame {
    protected final transient String source;
    protected final String command;
    protected final MultiMap<String> headers;
    protected final String payload;

    public SimpleFrame(String source, String command, String payload, MultiMap<String> headers) {
        this.command = Utils.isEmpty((String)command) ? "MESSAGE" : command;
        this.source = source;
        this.payload = payload;
        this.headers = headers;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public String getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.get(key);
    }

    @Override
    public MultiMap<String> getHeaderAll() {
        return this.headers;
    }

    public String toString() {
        return "Frame{command='" + this.command + '\'' + ", headers=" + this.headers + ", payload='" + this.payload + '\'' + '}';
    }
}

