/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.textstream;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.noear.solon.Utils;

public class ServerSentEvent
implements Serializable {
    private String data;
    private String id;
    private String event;
    private String retry;
    private String comment;

    public ServerSentEvent() {
    }

    public ServerSentEvent(Map<String, String> meta, String data) {
        if (data != null) {
            this.data = data.trim();
        }
        if (meta != null) {
            this.id = meta.get("id");
            this.event = meta.get("event");
            this.retry = meta.get("retry");
        }
    }

    public ServerSentEvent(String id, String event, String data, String retry) {
        this(id, event, data, retry, null);
    }

    public ServerSentEvent(String id, String event, String data, String retry, String comment) {
        this.id = id;
        this.event = event;
        this.retry = retry;
        if (data != null) {
            this.data = data.trim();
        }
        this.comment = comment;
    }

    public String getData() {
        return this.data;
    }

    public String getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }

    public String getRetry() {
        return this.retry;
    }

    public String getComment() {
        return this.comment;
    }

    @Deprecated
    public String id() {
        return this.id;
    }

    @Deprecated
    public String event() {
        return this.event;
    }

    @Deprecated
    public String data() {
        return this.data;
    }

    @Deprecated
    public String retry() {
        return this.retry;
    }

    @Deprecated
    public String comment() {
        return this.comment;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (Utils.isNotEmpty((String)this.id)) {
            buf.append("id:").append(this.id).append('\n');
        }
        if (Utils.isNotEmpty((String)this.event)) {
            buf.append("event:").append(this.event).append('\n');
        }
        if (Utils.isNotEmpty((String)this.data)) {
            buf.append("data:").append(this.data).append('\n');
        }
        if (Utils.isNotEmpty((String)this.retry)) {
            buf.append("retry:").append(this.retry).append('\n');
        }
        if (this.comment != null) {
            buf.append(':').append(this.comment.replace("\n", "\n:")).append('\n');
        }
        return buf.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ServerSentEvent sse = new ServerSentEvent();

        public Builder id(String id) {
            this.sse.id = id;
            return this;
        }

        public Builder event(String event) {
            this.sse.event = event;
            return this;
        }

        public Builder data(String data) {
            this.sse.data = data;
            return this;
        }

        public Builder retry(String retry) {
            this.sse.retry = retry;
            return this;
        }

        public Builder retry(Duration retry) {
            this.sse.retry = String.valueOf(retry.toMillis());
            return this;
        }

        public Builder comment(String comment) {
            this.sse.comment = comment;
            return this;
        }

        public ServerSentEvent build() {
            return this.sse;
        }
    }
}

