/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.noear.solon.Utils;
import org.noear.solon.net.http.HttpSslSupplier;

public class HttpSslSupplierDefault
implements HttpSslSupplier {
    private static HttpSslSupplier instance = new HttpSslSupplierDefault();
    private HostnameVerifier hostnameVerifier;
    private X509TrustManager x509TrustManager;

    public static HttpSslSupplier getInstance() {
        return instance;
    }

    @Override
    public SSLContext getSslContext() {
        try {
            return SSLContext.getDefault();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public SSLSocketFactory getSocketFactory() {
        return this.getSslContext().getSocketFactory();
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier == null) {
            Utils.locker().lock();
            try {
                if (this.hostnameVerifier == null) {
                    this.hostnameVerifier = new DefaultHostnameVerifier();
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.hostnameVerifier;
    }

    @Override
    public X509TrustManager getX509TrustManager() {
        if (this.x509TrustManager == null) {
            Utils.locker().lock();
            try {
                if (this.x509TrustManager == null) {
                    this.x509TrustManager = new DefaultX509TrustManager();
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.x509TrustManager;
    }

    public static class DefaultHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class DefaultX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

