/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.LoadBalanceUtils;

public class HttpUtilsBuilder {
    private String baseUri;
    private String group;
    private String service;
    private MultiMap<String> headers = new MultiMap();
    private HttpTimeout timeout;
    private Proxy proxy;

    public HttpUtilsBuilder service(String service) {
        this.service = service;
        return this;
    }

    public HttpUtilsBuilder service(String group, String service) {
        this.group = group;
        this.service = service;
        return this;
    }

    public HttpUtilsBuilder baseUri(String baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public HttpUtilsBuilder headerAdd(String key, String value) {
        this.headers.add(key, (Object)value);
        return this;
    }

    public HttpUtilsBuilder headerSet(String key, String value) {
        this.headers.put(key, (Object)value);
        return this;
    }

    public HttpUtilsBuilder timeout(int timeoutSeconds) {
        return this.timeout(HttpTimeout.of(timeoutSeconds));
    }

    public HttpUtilsBuilder timeout(int connectTimeoutSeconds, int writeTimeoutSeconds, int readTimeoutSeconds) {
        return this.timeout(HttpTimeout.of(connectTimeoutSeconds, writeTimeoutSeconds, readTimeoutSeconds));
    }

    public HttpUtilsBuilder timeout(HttpTimeout timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpUtilsBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpUtilsBuilder proxy(String host, int port) {
        return this.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
    }

    public HttpUtils build(String url) {
        if (Utils.isNotEmpty((String)this.service)) {
            this.baseUri = LoadBalanceUtils.getServer(this.group, this.service);
        }
        if (Utils.isNotEmpty((String)this.baseUri)) {
            url = PathUtil.joinUri((String)this.baseUri, (String)url);
        }
        return HttpUtils.http(url).headers((Iterable<KeyValues<String>>)this.headers).timeout(this.timeout).proxy(this.proxy);
    }
}

