/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import org.noear.solon.Solon;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.LoadBalanceUtils;
import org.noear.solon.net.http.impl.jdk.JdkHttpUtilsImpl;
import org.noear.solon.net.http.impl.okhttp.OkHttpUtilsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HttpUtils {
    public static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static HttpUtils http(String service, String path) {
        String url = LoadBalanceUtils.getServer(null, service) + path;
        return HttpUtils.http(url);
    }

    public static HttpUtils http(String group, String service, String path) {
        String url = LoadBalanceUtils.getServer(group, service) + path;
        return HttpUtils.http(url);
    }

    public static HttpUtils http(String url) {
        if (ClassUtil.hasClass(() -> OkHttpClient.class)) {
            return new OkHttpUtilsImpl(url);
        }
        return new JdkHttpUtilsImpl(url);
    }

    public HttpUtils serializer(Serializer var1);

    public Serializer serializer();

    public HttpUtils enablePrintln(boolean var1);

    public HttpUtils timeout(int var1);

    public HttpUtils timeout(int var1, int var2, int var3);

    public HttpUtils multipart(boolean var1);

    public HttpUtils userAgent(String var1);

    public HttpUtils charset(String var1);

    public HttpUtils headers(Map var1);

    public HttpUtils headers(Iterable<KeyValues<String>> var1);

    public HttpUtils header(String var1, String var2);

    public HttpUtils headerAdd(String var1, String var2);

    public HttpUtils cookies(Map var1);

    public HttpUtils cookies(Iterable<KeyValues<String>> var1);

    public HttpUtils cookie(String var1, String var2);

    public HttpUtils cookieAdd(String var1, String var2);

    public HttpUtils data(Map var1);

    public HttpUtils data(Iterable<KeyValues<String>> var1);

    public HttpUtils data(String var1, String var2);

    public HttpUtils data(String var1, String var2, InputStream var3, String var4);

    public HttpUtils data(String var1, String var2, File var3);

    default public HttpUtils data(String name, File file) {
        return this.data(name, file.getName(), file);
    }

    default public HttpUtils bodyOfTxt(String txt) {
        return this.body(txt, "text/plain");
    }

    default public HttpUtils bodyOfJson(String txt) {
        return this.body(txt, "application/json");
    }

    public HttpUtils bodyOfBean(Object var1) throws IOException;

    public HttpUtils body(String var1, String var2);

    public HttpUtils body(byte[] var1, String var2);

    default public HttpUtils body(byte[] bytes) {
        return this.body(bytes, null);
    }

    public HttpUtils body(InputStream var1, String var2);

    default public HttpUtils body(InputStream raw) {
        return this.body(raw, null);
    }

    public String get() throws IOException;

    public <T> T getAs(Type var1) throws IOException;

    public String post() throws IOException;

    public <T> T postAs(Type var1) throws IOException;

    default public String post(boolean useMultipart) throws IOException {
        if (useMultipart) {
            this.multipart(true);
        }
        return this.post();
    }

    default public <T> T postAs(Type type, boolean useMultipart) throws IOException {
        if (useMultipart) {
            this.multipart(true);
        }
        return this.postAs(type);
    }

    public String put() throws IOException;

    public <T> T putAs(Type var1) throws IOException;

    public String patch() throws IOException;

    public <T> T patchAs(Type var1) throws IOException;

    public String delete() throws IOException;

    public <T> T deleteAs(Type var1) throws IOException;

    public String options() throws IOException;

    public int head() throws IOException;

    public String execAsBody(String var1) throws IOException;

    public <T> T execAsBody(String var1, Type var2) throws IOException;

    public int execAsCode(String var1) throws IOException;

    public HttpResponse exec(String var1) throws IOException;

    public CompletableFuture<HttpResponse> execAsync(String var1);

    @Deprecated
    default public HttpUtils bodyTxt(String txt, String contentType) {
        log.warn("'HttpUtils.bodyTxt(.,.)' will be removed, please use 'HttpUtils.body(.,.)'!");
        return this.body(txt, contentType);
    }

    @Deprecated
    default public HttpUtils bodyTxt(String txt) {
        log.warn("'HttpUtils.bodyTxt(.)' will be removed, please use 'HttpUtils.bodyOfTxt(.)'!");
        return this.bodyOfTxt(txt);
    }

    @Deprecated
    default public HttpUtils bodyJson(String txt) {
        log.warn("'HttpUtils.bodyJson(.)' will be removed, please use 'HttpUtils.bodyOfJson(.)'!");
        return this.bodyOfJson(txt);
    }

    @Deprecated
    default public HttpUtils bodyRaw(byte[] bytes, String contentType) {
        log.warn("'HttpUtils.bodyRaw(.,.)' will be removed, please use 'HttpUtils.body(.,.)'!");
        return this.body(bytes, contentType);
    }

    @Deprecated
    default public HttpUtils bodyRaw(byte[] bytes) {
        log.warn("'HttpUtils.bodyRaw(.)' will be removed, please use 'HttpUtils.body(.)'!");
        return this.body(bytes);
    }

    @Deprecated
    default public HttpUtils bodyRaw(InputStream raw) {
        log.warn("'HttpUtils.bodyRaw(.)' will be removed, please use 'HttpUtils.body(.)'!");
        return this.body(raw);
    }

    @Deprecated
    default public HttpUtils bodyRaw(InputStream raw, String contentType) {
        log.warn("'HttpUtils.bodyRaw(.,.)' will be removed, please use 'HttpUtils.body(.,.)'!");
        return this.body(raw, contentType);
    }

    public static String urlEncode(String s) throws IOException {
        return HttpUtils.urlEncode(s, null);
    }

    public static String urlEncode(String s, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            return URLEncoder.encode(s, Solon.encoding());
        }
        return URLEncoder.encode(s, charset);
    }

    public static CharSequence toQueryString(Map<?, ?> map) throws IOException {
        return HttpUtils.toQueryString(map, null);
    }

    public static CharSequence toQueryString(Map<?, ?> map, String charset) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (buf.length() > 0) {
                buf.append('&');
            }
            buf.append(HttpUtils.urlEncode(entry.getKey().toString(), charset)).append('=').append(HttpUtils.urlEncode(entry.getValue().toString(), charset));
        }
        return buf.toString();
    }
}

