/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.http.HttpCallback;
import org.noear.solon.net.http.HttpExtension;
import org.noear.solon.net.http.HttpExtensionManager;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.impl.HttpInterceptorImpl;
import org.noear.solon.net.http.impl.HttpResponseImpl;
import org.noear.solon.net.http.impl.HttpTimeout;

public class HttpUtilsImpl
implements HttpUtils {
    private static final Supplier<Dispatcher> httpClientDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(20000);
        temp.setMaxRequestsPerHost(10000);
        return temp;
    };
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).dispatcher(httpClientDispatcher.get()).addInterceptor((Interceptor)HttpInterceptorImpl.instance).build();
    private OkHttpClient _client;
    private String _url;
    private Charset _charset;
    private MultiMap<String> _headers;
    private MultiMap<String> _cookies;
    private MultiMap<String> _params;
    private RequestBody _body;
    private boolean _multipart = false;
    private MultipartBody.Builder _part_builer;
    private final Request.Builder _builder;
    private HttpCallback _callback;
    private boolean _callAsync;
    private boolean _enablePrintln = false;

    public HttpUtilsImpl(String url) {
        this(url, null);
    }

    public HttpUtilsImpl(String url, OkHttpClient client) {
        this._client = client == null ? httpClient : client;
        if (!url.contains("://")) {
            throw new IllegalArgumentException("No url scheme 'http' or 'https' found: " + url);
        }
        this._url = url;
        this._builder = new Request.Builder().url(url);
        for (HttpExtension ext : HttpExtensionManager.getExtensions()) {
            ext.onInit(this, url);
        }
    }

    @Override
    public HttpUtils enablePrintln(boolean enable) {
        this._enablePrintln = enable;
        return this;
    }

    @Override
    public HttpUtilsImpl timeout(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            this._builder.tag(HttpTimeout.class, (Object)new HttpTimeout(timeoutSeconds));
        }
        return this;
    }

    @Override
    public HttpUtilsImpl timeout(int connectTimeoutSeconds, int writeTimeoutSeconds, int readTimeoutSeconds) {
        if (connectTimeoutSeconds > 0) {
            this._builder.tag(HttpTimeout.class, (Object)new HttpTimeout(connectTimeoutSeconds, writeTimeoutSeconds, readTimeoutSeconds));
        }
        return this;
    }

    @Override
    public HttpUtilsImpl multipart(boolean multipart) {
        this._multipart = multipart;
        return this;
    }

    @Override
    public HttpUtilsImpl userAgent(String ua) {
        this.tryInitHeaders().put("User-Agent", (Object)ua);
        return this;
    }

    @Override
    public HttpUtilsImpl charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    @Override
    public HttpUtilsImpl headers(Map headers) {
        if (headers != null) {
            this.tryInitHeaders();
            headers.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._headers.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils headers(Iterable<KeyValues<String>> headers) {
        if (headers != null) {
            this.tryInitHeaders();
            for (KeyValues<String> kv : headers) {
                this._headers.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtilsImpl header(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitHeaders().put(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtilsImpl headerAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitHeaders().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtilsImpl cookies(Map cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            cookies.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._cookies.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils cookies(Iterable<KeyValues<String>> cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            for (KeyValues<String> kv : cookies) {
                this._cookies.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils cookie(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitCookies().put(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils cookieAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitCookies().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtilsImpl data(Map data) {
        if (data != null) {
            this.tryInitParams();
            data.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._params.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils data(Iterable<KeyValues<String>> data) {
        if (data != null) {
            this.tryInitParams();
            for (KeyValues<String> kv : data) {
                this._params.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtilsImpl data(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitParams().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtilsImpl data(String key, String filename, InputStream inputStream, String contentType) {
        if (key == null || inputStream == null) {
            return this;
        }
        this.multipart(true);
        this.tryInitPartBuilder().addFormDataPart(key, filename, (RequestBody)new StreamBody(contentType, inputStream));
        return this;
    }

    @Override
    public HttpUtilsImpl bodyTxt(String txt) {
        return this.bodyTxt(txt, null);
    }

    @Override
    public HttpUtilsImpl bodyTxt(String txt, String contentType) {
        if (txt == null) {
            return this;
        }
        this._body = contentType == null ? FormBody.create(null, (String)txt) : FormBody.create((MediaType)MediaType.parse((String)contentType), (String)txt);
        return this;
    }

    @Override
    public HttpUtilsImpl bodyJson(String txt) {
        return this.bodyTxt(txt, "application/json");
    }

    @Override
    public HttpUtilsImpl bodyRaw(byte[] bytes) {
        return this.bodyRaw(bytes, null);
    }

    @Override
    public HttpUtilsImpl bodyRaw(byte[] bytes, String contentType) {
        return this.bodyRaw(new ByteArrayInputStream(bytes), contentType);
    }

    @Override
    public HttpUtilsImpl bodyRaw(InputStream raw) {
        return this.bodyRaw(raw, null);
    }

    @Override
    public HttpUtilsImpl bodyRaw(InputStream raw, String contentType) {
        if (raw == null) {
            return this;
        }
        this._body = new StreamBody(contentType, raw);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execCallback(Response resp, Exception err) {
        try {
            if (this._callback == null) {
                return;
            }
            if (resp != null) {
                this._callback.callback(resp.isSuccessful(), new HttpResponseImpl(resp), err);
            } else {
                this._callback.callback(false, null, err);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (resp != null) {
                resp.close();
            }
        }
    }

    private HttpResponse execDo(String mothod) throws IOException {
        if (this._headers != null) {
            this._headers.forEach(kv -> {
                for (String val : kv.getValues()) {
                    this._builder.addHeader(kv.getKey(), val);
                }
            });
        }
        if (this._multipart) {
            this.tryInitPartBuilder();
            if (this._params != null) {
                this._params.forEach(kv -> {
                    for (String val : kv.getValues()) {
                        this._part_builer.addFormDataPart(kv.getKey(), val);
                    }
                });
            }
            try {
                this._body = this._part_builer.build();
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (this._params != null) {
            Object _form_builer = new FormBody.Builder(this._charset);
            this._params.forEach(arg_0 -> HttpUtilsImpl.lambda$execDo$6((FormBody.Builder)_form_builer, arg_0));
            this._body = _form_builer.build();
        }
        if (this._cookies != null) {
            this._builder.header("Cookie", HttpUtilsImpl.getRequestCookieString(this._cookies));
        }
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method("GET", null);
                break;
            }
            case "POST": {
                this._builder.method("POST", this._body);
                break;
            }
            case "PUT": {
                this._builder.method("PUT", this._body);
                break;
            }
            case "DELETE": {
                this._builder.method("DELETE", this._body);
                break;
            }
            case "PATCH": {
                this._builder.method("PATCH", this._body);
                break;
            }
            case "HEAD": {
                this._builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                this._builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                this._builder.method("TRACE", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("This method is not supported");
            }
        }
        if (this._callAsync) {
            this._client.newCall(this._builder.build()).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    e.printStackTrace();
                    HttpUtilsImpl.this.execCallback(null, e);
                    call.cancel();
                }

                public void onResponse(Call call, Response response) throws IOException {
                    HttpUtilsImpl.this.execCallback(response, null);
                    call.cancel();
                }
            });
            return null;
        }
        Call call = this._client.newCall(this._builder.build());
        return new HttpResponseImpl(call.execute());
    }

    @Override
    public HttpResponse exec(String method) throws IOException {
        try {
            return this.execDo(method);
        }
        catch (IOException e) {
            throw new IOException(this._url + ", request failed", e);
        }
    }

    @Override
    public String execAsBody(String method) throws IOException {
        String text = this.exec(method).bodyAsString();
        if (this._enablePrintln) {
            System.out.println(this._url + ":: " + text);
        }
        return text;
    }

    @Override
    public int execAsCode(String method) throws IOException {
        int code = this.exec(method).code();
        if (this._enablePrintln) {
            System.out.println(this._url + "::code:: " + code);
        }
        return code;
    }

    @Override
    public String get() throws IOException {
        return this.execAsBody("GET");
    }

    @Override
    public String post() throws IOException {
        return this.execAsBody("POST");
    }

    @Override
    public void postAsync(HttpCallback callback) {
        this.execAsync("POST", callback);
    }

    @Override
    public void getAsync(HttpCallback callback) {
        this.execAsync("GET", callback);
    }

    @Override
    public void headAsync(HttpCallback callback) {
        this.execAsync("HEAD", callback);
    }

    @Override
    public void execAsync(String method, HttpCallback callback) {
        this._callback = callback;
        this._callAsync = true;
        try {
            this.execDo(method);
        }
        catch (IOException e) {
            throw new RuntimeException(this._url + ", request failed", e);
        }
    }

    @Override
    public String put() throws IOException {
        return this.execAsBody("PUT");
    }

    @Override
    public String patch() throws IOException {
        return this.execAsBody("PATCH");
    }

    @Override
    public String delete() throws IOException {
        return this.execAsBody("DELETE");
    }

    @Override
    public String options() throws IOException {
        return this.execAsBody("OPTIONS");
    }

    @Override
    public int head() throws IOException {
        return this.execAsCode("HEAD");
    }

    private static String getRequestCookieString(MultiMap<String> cookies) {
        StringBuilder sb = new StringBuilder();
        for (KeyValues kv : cookies) {
            for (String val : kv.getValues()) {
                sb.append(kv.getKey()).append('=').append(val).append("; ");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private MultipartBody.Builder tryInitPartBuilder() {
        if (this._part_builer == null) {
            this._part_builer = new MultipartBody.Builder().setType(MultipartBody.FORM);
        }
        return this._part_builer;
    }

    private MultiMap<String> tryInitParams() {
        if (this._params == null) {
            this._params = new MultiMap();
        }
        return this._params;
    }

    private MultiMap<String> tryInitCookies() {
        if (this._cookies == null) {
            this._cookies = new MultiMap();
        }
        return this._cookies;
    }

    private MultiMap<String> tryInitHeaders() {
        if (this._headers == null) {
            this._headers = new MultiMap();
        }
        return this._headers;
    }

    private static /* synthetic */ void lambda$execDo$6(FormBody.Builder _form_builer, KeyValues kv) {
        for (String val : kv.getValues()) {
            _form_builer.add(kv.getKey(), val);
        }
    }

    public static class StreamBody
    extends RequestBody {
        private MediaType _contentType = null;
        private InputStream _inputStream = null;

        public StreamBody(String contentType, InputStream inputStream) {
            if (contentType != null) {
                this._contentType = MediaType.parse((String)contentType);
            }
            this._inputStream = inputStream;
        }

        public MediaType contentType() {
            return this._contentType;
        }

        public long contentLength() throws IOException {
            return this._inputStream.available();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((InputStream)this._inputStream);
                sink.writeAll(source);
            }
            finally {
                Util.closeQuietly((Closeable)source);
            }
        }
    }
}

