/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.mvc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarSpec;

public class ActionExecuteHandlerDefault
implements ActionExecuteHandler {
    public boolean matched(Context ctx, String mime) {
        return true;
    }

    public Object executeHandle(Context ctx, Object target, MethodWrap mWrap) throws Throwable {
        Object[] args = this.resolveArguments(ctx, target, mWrap);
        return mWrap.invokeByAspect(target, args);
    }

    public Object[] resolveArguments(Context ctx, Object target, MethodWrap mWrap) throws Throwable {
        return this.buildArgs(ctx, target, mWrap).toArray();
    }

    protected List<Object> buildArgs(Context ctx, Object target, MethodWrap mWrap) throws Exception {
        ParamWrap[] pSet = mWrap.getParamWraps();
        ArrayList<Object> args = new ArrayList<Object>(pSet.length);
        Object bodyObj = this.changeBody(ctx, mWrap);
        int len = pSet.length;
        for (int i = 0; i < len; ++i) {
            ParamWrap p = pSet[i];
            Class pt = p.getType();
            if (Context.class.isAssignableFrom(pt)) {
                args.add(ctx);
                continue;
            }
            if (ModelAndView.class.isAssignableFrom(pt)) {
                args.add(new ModelAndView());
                continue;
            }
            if (Locale.class.isAssignableFrom(pt)) {
                args.add(ctx.getLocale());
                continue;
            }
            if (UploadedFile.class == pt) {
                args.add(ctx.file(p.spec().getName()));
                continue;
            }
            if (UploadedFile[].class == pt) {
                args.add(ctx.fileValues(p.spec().getName()));
                continue;
            }
            Object tv = ctx.pull(pt);
            if (tv == null && p.spec().isRequiredBody()) {
                if (String.class.equals((Object)pt)) {
                    tv = ctx.bodyNew();
                } else if (InputStream.class.equals((Object)pt)) {
                    tv = ctx.bodyAsStream();
                } else if (Map.class.equals((Object)pt) && bodyObj instanceof MultiMap) {
                    tv = ((MultiMap)bodyObj).toValueMap();
                }
            }
            if (tv == null) {
                try {
                    tv = this.changeValue(ctx, p, i, pt, bodyObj);
                }
                catch (ConstructionException e) {
                    throw e;
                }
                catch (Exception e) {
                    String methodFullName = mWrap.getDeclaringClz().getName() + "::" + mWrap.getName() + "@" + p.spec().getName();
                    throw new StatusException("Action parameter change failed: " + methodFullName, (Throwable)e, 400);
                }
            }
            if (tv == null && pt.isPrimitive()) {
                if (pt == Short.TYPE) {
                    tv = (short)0;
                } else if (pt == Integer.TYPE) {
                    tv = 0;
                } else if (pt == Long.TYPE) {
                    tv = 0L;
                } else if (pt == Double.TYPE) {
                    tv = 0.0;
                } else if (pt == Float.TYPE) {
                    tv = Float.valueOf(0.0f);
                } else if (pt == Boolean.TYPE) {
                    tv = false;
                } else {
                    throw new IllegalArgumentException("Please enter a valid parameter @" + p.spec().getName());
                }
            }
            if (tv == null && p.spec().isRequiredInput()) {
                throw new StatusException(p.spec().getRequiredHint(), 400);
            }
            args.add(tv);
        }
        return args;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ctx.paramMap();
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        String pn = p.spec().getName();
        String pv = p.spec().getValue(ctx);
        Object tv = null;
        if (pv == null) {
            pv = p.spec().getDefaultValue();
        }
        tv = pv == null ? (UploadedFile.class == pt ? ctx.file(pn) : (UploadedFile[].class == pt ? ctx.fileValues(pn) : (pn.startsWith("$") ? ctx.attr(pn) : (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive() || pt.isEnum() ? null : this.changeEntityDo(ctx, p, pn, pt))))) : this.changeValueDo(ctx, p, pn, pt, pv);
        return tv;
    }

    protected Object changeValueDo(Context ctx, ParamWrap p, String name, Class<?> type, String value) {
        return ConvertUtil.to((VarSpec)p.spec(), (String)value, (Context)ctx);
    }

    protected Object changeEntityDo(Context ctx, ParamWrap p, String name, Class<?> type) throws Exception {
        ClassWrap clzW = ClassWrap.get(type);
        MultiMap map = ctx.paramMap();
        return clzW.newBy(arg_0 -> ((MultiMap)map).get(arg_0), ctx);
    }
}

